/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.fields.proposal.nls;

import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalProvider;

public class NlsTextProposal
implements Comparable<NlsTextProposal> {
    public static final NlsTextProposal NEW_NLS_TEXT_PROPOSAL = new NlsTextProposal(null, null, true){

        @Override
        public String toString() {
            return "NEW_NLS_TEXT_PROPOSAL";
        }
    };
    public static final int MATCH_DEV_LANG_TRANSLATION = 1;
    public static final int MATCH_KEY = 2;
    public static final int MATCH_FOREIGN_LANG = 4;
    private static final Pattern REGEX_CR = Pattern.compile("\r", 16);
    private static final Pattern REGEX_LF = Pattern.compile("\n", 16);
    private static final String KEY_PREFIX = " (";
    private static final String FOREIGN_LANG_PREFIX = "=";
    private int m_matchKind;
    private String m_matchedForeignLangTranslation;
    private final boolean m_isNewEntryProposal;
    private final INlsEntry m_entry;
    private final Language m_developmentLanguage;
    private final String m_devLangTranslation;
    private final String[] m_foreignLangTranslations;

    public NlsTextProposal(INlsEntry entry, Language developmentLanguage) {
        this(entry, developmentLanguage, false);
    }

    private NlsTextProposal(INlsEntry entry, Language developmentLanguage, boolean isNewEntryProposal) {
        this.m_entry = entry;
        this.m_developmentLanguage = developmentLanguage;
        if (this.m_entry != null) {
            this.m_devLangTranslation = this.m_entry.getTranslation(developmentLanguage, true);
            Map allTranslations = entry.getAllTranslations();
            ArrayList<String> foreignLangTranslations = new ArrayList<String>(allTranslations.size());
            for (Map.Entry e : allTranslations.entrySet()) {
                if (developmentLanguage.equals(e.getKey())) continue;
                foreignLangTranslations.add((String)e.getValue());
            }
            this.m_foreignLangTranslations = foreignLangTranslations.toArray(new String[foreignLangTranslations.size()]);
        } else {
            this.m_devLangTranslation = null;
            this.m_foreignLangTranslations = null;
        }
        this.m_isNewEntryProposal = isNewEntryProposal;
    }

    public INlsEntry getEntry() {
        return this.m_entry;
    }

    public boolean matches(ContentProposalProvider.NormalizedPattern pattern) {
        this.m_matchedForeignLangTranslation = null;
        if (NlsTextProposal.matches(this.getDevLangTranslation(), pattern)) {
            this.m_matchKind = 1;
            return true;
        }
        if (NlsTextProposal.matches(this.getKey(), pattern)) {
            this.m_matchKind = 2;
            return true;
        }
        String[] stringArray = this.getForeignLangTranslations();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (NlsTextProposal.matches(s, pattern)) {
                this.m_matchKind = 4;
                this.m_matchedForeignLangTranslation = s;
                return true;
            }
            ++n2;
        }
        this.m_matchKind = 0;
        return false;
    }

    public String getMatchedForeignLangTranslation() {
        return this.m_matchedForeignLangTranslation;
    }

    public int[] getMatchingRegions(ContentProposalProvider.NormalizedPattern pattern) {
        int offset = 0;
        switch (this.getMatchKind()) {
            case 1: {
                return ContentProposalProvider.getMatchingRegions(this, this.getDevLangTranslation(), pattern);
            }
            case 2: {
                offset = this.getDevLangTranslation().length() + KEY_PREFIX.length();
                return this.adapt(ContentProposalProvider.getMatchingRegions(this, this.getKey(), pattern), offset);
            }
            case 4: {
                offset = this.getDevLangTranslation().length() + KEY_PREFIX.length() + this.getKey().length() + FOREIGN_LANG_PREFIX.length();
                return this.adapt(ContentProposalProvider.getMatchingRegions(this, this.getMatchedForeignLangTranslation(), pattern), offset);
            }
        }
        return null;
    }

    public String getDisplayText() {
        StringBuilder sb = new StringBuilder(this.getDevLangTranslation());
        sb.append(KEY_PREFIX);
        sb.append(this.getKey());
        if (this.getMatchKind() == 4) {
            sb.append(FOREIGN_LANG_PREFIX);
            sb.append(this.getMatchedForeignLangTranslation());
        }
        sb.append(")");
        String ret = sb.toString();
        ret = REGEX_CR.matcher(ret).replaceAll("");
        ret = REGEX_LF.matcher(ret).replaceAll(" ");
        return ret;
    }

    private int[] adapt(int[] matchingRegions, int offset) {
        int i = 0;
        while (i < matchingRegions.length) {
            int n = i;
            matchingRegions[n] = matchingRegions[n] + offset;
            i += 2;
        }
        return matchingRegions;
    }

    public int getMatchKind() {
        return this.m_matchKind;
    }

    public String getKey() {
        return this.m_entry.getKey();
    }

    public String getDevLangTranslation() {
        return this.m_devLangTranslation;
    }

    public String[] getForeignLangTranslations() {
        return this.m_foreignLangTranslations;
    }

    private static boolean matches(String text, ContentProposalProvider.NormalizedPattern pattern) {
        return SearchPattern.getMatchingRegions((String)pattern.getPattern(), (String)text, (int)pattern.getMatchKind()) != null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof NlsTextProposal)) {
            return false;
        }
        return CompareUtility.equals((Object)this.m_entry, (Object)((NlsTextProposal)obj).m_entry);
    }

    public int hashCode() {
        if (this.m_entry == null) {
            return 0;
        }
        return this.m_entry.hashCode();
    }

    private String getSortString() {
        if (this.getMatchKind() == 1) {
            return StringUtility.lowercase((String)this.getDevLangTranslation());
        }
        if (this.getMatchKind() == 2) {
            return StringUtility.lowercase((String)this.getKey());
        }
        return StringUtility.lowercase((String)this.getMatchedForeignLangTranslation());
    }

    public String toString() {
        String NULL_STRING = "<NULL>";
        if (this.m_entry == null) {
            return "<NULL>";
        }
        String txt = this.m_entry.getTranslation(this.m_entry.getProject().getDevelopmentLanguage());
        txt = txt == null ? "<NULL>" : txt.replace('\r', '\n').replaceAll("\n", "");
        return this.m_entry.getKey() + '=' + txt;
    }

    @Override
    public int compareTo(NlsTextProposal o) {
        return CompareUtility.compareTo((Comparable)((Object)this.getSortString()), (Comparable)((Object)o.getSortString()));
    }

    public boolean isNewEntryProposal() {
        return this.m_isNewEntryProposal;
    }

    public Language getDevelopmentLanguage() {
        return this.m_developmentLanguage;
    }

    /* synthetic */ NlsTextProposal(INlsEntry iNlsEntry, Language language, boolean bl, NlsTextProposal nlsTextProposal) {
        this(iNlsEntry, language, bl);
    }
}

