/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.extensions.ICopySourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IPasteTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;

public class CopyAndPasteExtensionPoint {
    private static final String extensionPointName = "outlineCopyAndPaste";
    private static final String pasteDelegatorAttName = "pasteTargetDelegator";
    private static final String copyDelegatorAttName = "copySourceDelegator";
    private static CopyAndPasteExtensionPoint instance = new CopyAndPasteExtensionPoint();
    private List<IPasteTargetDelegator> m_pasteTargetDelegators;
    private List<ICopySourceDelegator> m_copySourceDelegators;

    private CopyAndPasteExtensionPoint() {
        this.init();
    }

    private void init() {
        IExtension[] extensions;
        ArrayList<IPasteTargetDelegator> pasteDelegators = new ArrayList<IPasteTargetDelegator>();
        ArrayList<ICopySourceDelegator> copyDelegators = new ArrayList<ICopySourceDelegator>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", extensionPointName);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    if (element.getAttribute(pasteDelegatorAttName) != null) {
                        IPasteTargetDelegator pasteDelegator = (IPasteTargetDelegator)element.createExecutableExtension(pasteDelegatorAttName);
                        pasteDelegators.add(pasteDelegator);
                    } else if (element.getAttribute(copyDelegatorAttName) != null) {
                        ICopySourceDelegator copyDelegator = (ICopySourceDelegator)element.createExecutableExtension(copyDelegatorAttName);
                        copyDelegators.add(copyDelegator);
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError("Could not create an executable extension of point '" + extension.getExtensionPointUniqueIdentifier() + "'.");
                }
                ++n4;
            }
            ++n2;
        }
        this.m_pasteTargetDelegators = pasteDelegators;
        this.m_copySourceDelegators = copyDelegators;
    }

    public static IPasteTargetDelegator[] getPasteTargetDelegators() {
        return instance.getPasteTargetDelegatorsImpl();
    }

    private IPasteTargetDelegator[] getPasteTargetDelegatorsImpl() {
        return this.m_pasteTargetDelegators.toArray(new IPasteTargetDelegator[this.m_pasteTargetDelegators.size()]);
    }

    public static ICopySourceDelegator[] getCopySourceDelegators() {
        return instance.getCopySourceDelegatorsImpl();
    }

    private ICopySourceDelegator[] getCopySourceDelegatorsImpl() {
        return this.m_copySourceDelegators.toArray(new ICopySourceDelegator[this.m_copySourceDelegators.size()]);
    }
}

