/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.ui.extensions.IPageFactory;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.osgi.framework.Bundle;

public final class ExplorerPageExtensionPoint {
    public static final String EXPLORER_PAGE_EXTENSION_ID = "explorerPage";
    public static final String PARENT_PAGE_ATTRIBUTE = "parentPageId";
    public static final String PAGE_ATTRIBUTE = "page";
    public static final String PAGE_FACTORY_ATTRIBUTE = "pageFactory";
    private final HashMap<String, List<ExplorerPageExtension>> m_pages = new HashMap();
    private static final ExplorerPageExtensionPoint instance = new ExplorerPageExtensionPoint();

    private ExplorerPageExtensionPoint() {
        this.init();
    }

    private void init() {
        IExtension[] extensions;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", EXPLORER_PAGE_EXTENSION_ID);
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle contributerBundle;
                ExplorerPageExtension pageExt;
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (PAGE_ATTRIBUTE.equals(element.getName())) {
                    pageExt = new ExplorerPageExtension();
                    pageExt.setParentPageId(element.getAttribute(PARENT_PAGE_ATTRIBUTE));
                    contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                    pageExt.setPageClass(this.getClassOfContribution(contributerBundle, element, PAGE_ATTRIBUTE, IPage.class));
                    this.addExtension(pageExt);
                } else if (PAGE_FACTORY_ATTRIBUTE.equals(element.getName())) {
                    pageExt = new ExplorerPageExtension();
                    pageExt.setParentPageId(element.getAttribute(PARENT_PAGE_ATTRIBUTE));
                    contributerBundle = Platform.getBundle((String)extension.getNamespaceIdentifier());
                    pageExt.setFactoryClass(this.getClassOfContribution(contributerBundle, element, "factory", IPageFactory.class));
                    this.addExtension(pageExt);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void addExtension(ExplorerPageExtension page) {
        List<ExplorerPageExtension> childNodes = this.m_pages.get(page.getParentPageId());
        if (childNodes == null) {
            childNodes = new ArrayList<ExplorerPageExtension>();
            this.m_pages.put(page.getParentPageId(), childNodes);
        }
        childNodes.add(page);
    }

    private <T> Class<? extends T> getClassOfContribution(Bundle bundle, IConfigurationElement element, String attribute, Class<T> t) {
        Class clazz = null;
        if (bundle != null) {
            String clazzName = element.getAttribute(attribute);
            if (StringUtility.hasText((String)clazzName)) {
                try {
                    clazz = bundle.loadClass(clazzName);
                }
                catch (Exception tt) {
                    ScoutSdkUi.logWarning("could not load class of extension '" + element.getName() + "'.", tt);
                }
            } else {
                ScoutSdkUi.logWarning("page extension without class found. Contributed in bundle '" + bundle.getSymbolicName() + "'. Will be ignored.");
            }
        }
        return clazz;
    }

    public static ExplorerPageExtension[] getExtensions(IPage parentPage) {
        return instance.getExtensionsImpl(parentPage);
    }

    private ExplorerPageExtension[] getExtensionsImpl(IPage parentPage) {
        List<ExplorerPageExtension> list = this.m_pages.get(parentPage.getPageId());
        if (list != null) {
            return list.toArray(new ExplorerPageExtension[list.size()]);
        }
        return new ExplorerPageExtension[0];
    }

    public static class ExplorerPageExtension {
        private Class<? extends IPage> m_pageClass;
        private Class<? extends IPageFactory> m_factoryClass;
        private String m_parentPageId;

        public void setPageClass(Class<? extends IPage> pageClass) {
            this.m_pageClass = pageClass;
        }

        public Class<? extends IPage> getPageClass() {
            return this.m_pageClass;
        }

        public IPage createPageInstance() {
            try {
                return this.getPageClass().newInstance();
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not instanciate class '" + this.getPageClass().getName() + "'.", e);
                return null;
            }
        }

        public void setFactoryClass(Class<? extends IPageFactory> factoryClass) {
            this.m_factoryClass = factoryClass;
        }

        public Class<? extends IPageFactory> getFactoryClass() {
            return this.m_factoryClass;
        }

        public IPageFactory createFactoryClass() {
            try {
                return this.getFactoryClass().newInstance();
            }
            catch (Exception e) {
                ScoutSdkUi.logError("could not instanciate class '" + this.getFactoryClass().getName() + "'.");
                return null;
            }
        }

        public String getParentPageId() {
            return this.m_parentPageId;
        }

        private void setParentPageId(String parentPageId) {
            this.m_parentPageId = parentPageId;
        }
    }
}

