/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.scout.sdk.ui.extensions.technology.IScoutTechnologyHandler;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.technology.Technology;

public final class TechnologyExtensionPoint {
    public static final String EXTENSION_ID = "technology";
    public static final String TAG_TECH = "technology";
    public static final String TAG_HANDLER = "handler";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ID = "id";
    public static final String ATTR_TECH = "technology";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_CATEGORY = "category";
    private static volatile HashSet<Technology> technologies;
    private static final Object lock;

    static {
        lock = new Object();
    }

    private TechnologyExtensionPoint() {
    }

    private static Map<String, ArrayList<IScoutTechnologyHandler>> getHandlers() {
        IExtension[] extensions;
        HashMap<String, ArrayList<IScoutTechnologyHandler>> techHandlers = new HashMap<String, ArrayList<IScoutTechnologyHandler>>();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "technology");
        IExtension[] iExtensionArray = extensions = xp.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (TAG_HANDLER.equals(element.getName())) {
                    try {
                        String techId = element.getAttribute("technology");
                        ArrayList<IScoutTechnologyHandler> handlers = techHandlers.get(techId);
                        if (handlers == null) {
                            handlers = new ArrayList();
                            techHandlers.put(techId, handlers);
                        }
                        IScoutTechnologyHandler handler = (IScoutTechnologyHandler)element.createExecutableExtension(ATTR_CLASS);
                        handlers.add(handler);
                    }
                    catch (CoreException e) {
                        ScoutSdkUi.logError("Unable to load technology handler class '" + element.getAttribute(ATTR_CLASS) + "'", e);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return techHandlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Technology[] getTechnologyExtensions() {
        if (technologies == null) {
            Object object = lock;
            synchronized (object) {
                if (technologies == null) {
                    IExtension[] extensions;
                    Map<String, ArrayList<IScoutTechnologyHandler>> handlers = TechnologyExtensionPoint.getHandlers();
                    HashSet<Technology> techs = new HashSet<Technology>();
                    IExtensionRegistry reg = Platform.getExtensionRegistry();
                    IExtensionPoint xp = reg.getExtensionPoint("org.eclipse.scout.sdk.ui", "technology");
                    IExtension[] iExtensionArray = extensions = xp.getExtensions();
                    int n = extensions.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IConfigurationElement[] elements;
                        IExtension extension = iExtensionArray[n2];
                        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
                        int n3 = elements.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IConfigurationElement element = iConfigurationElementArray[n4];
                            if ("technology".equals(element.getName())) {
                                String id = element.getAttribute(ATTR_ID);
                                String name = element.getAttribute(ATTR_NAME);
                                String category = element.getAttribute(ATTR_CATEGORY);
                                if (category != null && category.trim().length() < 1) {
                                    category = null;
                                }
                                if (name != null && id != null && name.trim().length() > 0 && id.trim().length() > 0) {
                                    Technology t = new Technology(id, name, category);
                                    t.addAllHandlers((Collection<IScoutTechnologyHandler>)handlers.get(id));
                                    techs.add(t);
                                }
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    technologies = techs;
                }
            }
        }
        return technologies.toArray(new Technology[technologies.size()]);
    }
}

