/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.sql;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.codecompletion.sql.SqlBindProposal;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.ITypeHierarchy;
import org.eclipse.swt.graphics.Image;

public class SqlBindCompletionProposalProcessor {
    private final IType AbstractFormData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.AbstractFormData");
    private final IType AbstractFormFieldData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.fields.AbstractFormFieldData");
    private final IType AbstractPropertyData = TypeUtility.getType((String)"org.eclipse.scout.rt.shared.data.form.properties.AbstractPropertyData");
    private final Image m_image = ScoutSdkUi.getImage("default.gif");
    private static final Pattern REGEX_QUOTES = Pattern.compile("\\\"");
    private static final Pattern REGEX_BIND = Pattern.compile(".*\\:[A-Za-z0-9\\._-]*$");

    public List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            SqlBindProposal prop;
            String propName;
            IType t;
            if (!SqlBindCompletionProposalProcessor.isSqlStatementLocation(context.getViewer(), context.getInvocationOffset())) {
                return Collections.emptyList();
            }
            IType formData = this.getFormDataParameterType(context);
            if (formData == null || !formData.exists()) {
                return Collections.emptyList();
            }
            String prefix = SqlBindCompletionProposalProcessor.getPrefix(context.getViewer(), context.getInvocationOffset());
            HashSet<ICompletionProposal> collector = new HashSet<ICompletionProposal>();
            ITypeHierarchy hierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{formData});
            IType[] iTypeArray = TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)this.AbstractFormFieldData, (ITypeHierarchy)hierarchy));
            int n = iTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                t = iTypeArray[n2];
                propName = NamingUtility.ensureStartWithLowerCase((String)t.getElementName());
                prop = new SqlBindProposal(propName, prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
                this.addInnerTypesInSuperClasses(t, t.newSupertypeHierarchy(null), collector, prefix, String.valueOf(propName) + ".", context);
                ++n2;
            }
            iTypeArray = TypeUtility.getInnerTypes((IType)formData, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)this.AbstractPropertyData, (ITypeHierarchy)hierarchy));
            n = iTypeArray.length;
            n2 = 0;
            while (n2 < n) {
                t = iTypeArray[n2];
                propName = t.getElementName();
                propName = NamingUtility.ensureStartWithLowerCase((String)propName.replaceAll("Property$", ""));
                prop = new SqlBindProposal(propName, prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
                ++n2;
            }
            TreeMap<String, ICompletionProposal> sorted = new TreeMap<String, ICompletionProposal>();
            for (ICompletionProposal p : collector) {
                if (!p.getDisplayString().toLowerCase().startsWith(prefix.toLowerCase())) continue;
                sorted.put(p.getDisplayString(), p);
            }
            return CollectionUtility.arrayList(sorted.values());
        }
        catch (Exception e) {
            ScoutSdkUi.logWarning("error during creating sql copletion.", e);
            return Collections.emptyList();
        }
    }

    private void addInnerTypesInSuperClasses(IType baseType, org.eclipse.jdt.core.ITypeHierarchy baseTypeSuperHierarchy, HashSet<ICompletionProposal> collector, String prefix, String namePrefix, JavaContentAssistInvocationContext context) throws JavaModelException {
        IType[] iTypeArray = baseTypeSuperHierarchy.getAllSuperclasses(baseType);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType superClass = iTypeArray[n2];
            ITypeHierarchy hierarchy = TypeUtility.getLocalTypeHierarchy((IJavaElement[])new IJavaElement[]{superClass});
            IType[] iTypeArray2 = TypeUtility.getInnerTypes((IType)superClass, (ITypeFilter)TypeFilters.getSubtypeFilter((IType)this.AbstractFormFieldData, (ITypeHierarchy)hierarchy));
            int n3 = iTypeArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IType innerType = iTypeArray2[n4];
                SqlBindProposal prop = new SqlBindProposal(String.valueOf(namePrefix) + NamingUtility.ensureStartWithLowerCase((String)innerType.getElementName()), prefix, context.getInvocationOffset(), this.m_image);
                collector.add(prop);
                this.addInnerTypesInSuperClasses(innerType, innerType.newSupertypeHierarchy(null), collector, prefix, String.valueOf(prop.getDisplayString()) + ".", context);
                ++n4;
            }
            ++n2;
        }
    }

    private static boolean isSqlStatementLocation(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return false;
        }
        IRegion lineInfo = doc.getLineInformationOfOffset(offset);
        String linePart = doc.get(lineInfo.getOffset(), offset - lineInfo.getOffset());
        Matcher m = REGEX_QUOTES.matcher(linePart);
        boolean stringLocation = false;
        while (m.find()) {
            boolean bl = stringLocation = !stringLocation;
        }
        if (stringLocation) {
            stringLocation = REGEX_BIND.matcher(linePart).matches();
        }
        return stringLocation;
    }

    private IType getFormDataParameterType(JavaContentAssistInvocationContext context) throws JavaModelException {
        IJavaElement element = context.getCoreContext().getEnclosingElement();
        if (element.getElementType() == 9) {
            IMethod method = (IMethod)element;
            String[] stringArray = method.getParameterTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fqn;
                IType candidate;
                String parameter = stringArray[n2];
                String fqs = SignatureUtility.getQualifiedSignature((String)parameter, (IType)method.getDeclaringType());
                if (SignatureUtility.getTypeSignatureKind((String)fqs) == 1 && (candidate = TypeUtility.getType((String)(fqn = String.valueOf(Signature.getSignatureQualifier((String)fqs)) + "." + Signature.getSignatureSimpleName((String)fqs)))).newSupertypeHierarchy(null).contains(this.AbstractFormData)) {
                    return candidate;
                }
                ++n2;
            }
        }
        return null;
    }

    private static String getPrefix(ITextViewer viewer, int offset) throws BadLocationException {
        IDocument doc = viewer.getDocument();
        if (doc == null || offset > doc.getLength()) {
            return null;
        }
        int length = 0;
        while (--offset >= 0 && (Character.isLetterOrDigit(doc.getChar(offset)) || doc.getChar(offset) == '.' || doc.getChar(offset) == '_' || doc.getChar(offset) == '-')) {
            ++length;
        }
        return doc.get(offset + 1, length);
    }
}

