/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.clipboard;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.scout.sdk.ui.extensions.ICopySourceDelegator;
import org.eclipse.scout.sdk.ui.extensions.IPasteTargetDelegator;
import org.eclipse.scout.sdk.ui.internal.extensions.CopyAndPasteExtensionPoint;
import org.eclipse.scout.sdk.ui.view.outline.OutlineCopySourceEvent;
import org.eclipse.scout.sdk.ui.view.outline.OutlinePasteTargetEvent;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;

public class ExplorerCopyAndPasteSupport {
    public static boolean performPaste(TreeViewer viewer, IPage page) {
        OutlinePasteTargetEvent event = new OutlinePasteTargetEvent(viewer);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        event.setTransferData(clipboard.getContents(null));
        event.setPage(page);
        boolean res = false;
        IPasteTargetDelegator[] iPasteTargetDelegatorArray = CopyAndPasteExtensionPoint.getPasteTargetDelegators();
        int n = iPasteTargetDelegatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPasteTargetDelegator del = iPasteTargetDelegatorArray[n2];
            res |= del.performPaste(event);
            ++n2;
        }
        return res;
    }

    public static boolean performCopy(TreeViewer viewer, IPage page) {
        OutlineCopySourceEvent event = new OutlineCopySourceEvent(viewer);
        event.setPage(page);
        boolean res = false;
        ICopySourceDelegator[] iCopySourceDelegatorArray = CopyAndPasteExtensionPoint.getCopySourceDelegators();
        int n = iCopySourceDelegatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICopySourceDelegator del = iCopySourceDelegatorArray[n2];
            res |= del.performCopy(event);
            ++n2;
        }
        return res;
    }
}

