/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.job;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.jobs.AbstractWorkspaceBlockingJob;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerPart;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class LoadInitialOutlineJob
extends AbstractWorkspaceBlockingJob {
    private ScoutExplorerPart m_view;

    public LoadInitialOutlineJob(ScoutExplorerPart view) {
        super(String.valueOf(Texts.get((String)"LoadingScoutExplorer")) + "...");
        this.m_view = view;
    }

    protected void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        Control c = this.m_view.getTreeViewer().getControl();
        if (c.isDisposed()) {
            return;
        }
        Display display = c.getDisplay();
        IPage rootPage = this.m_view.getRootPage();
        final Cursor waitCursor = new Cursor((Device)display, 1);
        try {
            display.syncExec(new Runnable(){

                @Override
                public void run() {
                    LoadInitialOutlineJob.this.m_view.getTreeViewer().getControl().setCursor(waitCursor);
                    LoadInitialOutlineJob.this.m_view.getViewContentProvider().setAutoLoadChildren(false);
                }
            });
            if (rootPage != null) {
                this.loadNodeRec(rootPage, monitor);
            }
        }
        catch (Throwable throwable) {
            display.asyncExec(new Runnable(monitor, waitCursor){
                private final /* synthetic */ IProgressMonitor val$monitor;
                private final /* synthetic */ Cursor val$waitCursor;
                {
                    this.val$monitor = iProgressMonitor;
                    this.val$waitCursor = cursor;
                }

                @Override
                public void run() {
                    if (!LoadInitialOutlineJob.this.m_view.getTreeViewer().getTree().isDisposed()) {
                        if (!this.val$monitor.isCanceled()) {
                            LoadInitialOutlineJob.this.m_view.expandAndSelectProjectLevel();
                            LoadInitialOutlineJob.this.m_view.getTreeViewer().refresh();
                            LoadInitialOutlineJob.this.m_view.getViewContentProvider().setAutoLoadChildren(true);
                        }
                        LoadInitialOutlineJob.this.m_view.getTreeViewer().getControl().setCursor(null);
                    }
                    this.val$waitCursor.dispose();
                }
            });
            throw throwable;
        }
        display.asyncExec(new /* invalid duplicate definition of identical inner class */);
    }

    private void loadNodeRec(IPage page, IProgressMonitor monitor) {
        if (page.isInitiallyLoaded()) {
            if (monitor.isCanceled()) {
                return;
            }
            monitor.subTask("Loading " + page.getName() + "...");
            if (!page.isChildrenLoaded()) {
                page.loadChildren();
            }
            IPage[] iPageArray = page.getChildArray();
            int n = iPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPage childPage = iPageArray[n2];
                this.loadNodeRec(childPage, monitor);
                if (monitor.isCanceled()) {
                    return;
                }
                ++n2;
            }
        }
    }
}

