/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.internal.workspace.ScoutWorkspace;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.ITypeResolver;
import org.eclipse.scout.sdk.operation.util.wellform.WellformClientBundleOperation;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.WellformAction;
import org.eclipse.scout.sdk.ui.action.create.ScoutProjectNewAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverFormDataAction;
import org.eclipse.scout.sdk.ui.action.dto.TypeResolverPageDataAction;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.ScoutExplorerSettingsSupport;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.BundleNodeGroupTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleTreeModel;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutExplorerSettingsBundleFilter;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutWorkingSetTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IPrimaryTypeTypeHierarchy;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.IScoutWorkspaceListener;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;
import org.eclipse.scout.sdk.workspace.ScoutWorkspaceEvent;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class ProjectsTablePage
extends AbstractPage {
    private final IScoutWorkspaceListener m_workspaceListener = new IScoutWorkspaceListener(){

        public void workspaceChanged(ScoutWorkspaceEvent event) {
            switch (event.getType()) {
                case 1: 
                case 2: 
                case 3: {
                    ProjectsTablePage.this.markStructureDirty();
                }
            }
        }
    };
    private final IPropertyChangeListener m_explorerConfigChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("org.eclipse.scout.sdk.ui.view.scoutExplorer.bundleDisplayStyle".equals(event.getProperty()) || "org.eclipse.scout.sdk.view.ui.scoutExplorer.showFragments".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.showBinaryBundles".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenBundleTypes".equals(event.getProperty())) {
                ProjectsTablePage.this.markStructureDirty();
            } else if (("org.eclipse.scout.sdk.ui.view.scoutExplorer.hiddenWorkingSets".equals(event.getProperty()) || "org.eclipse.scout.sdk.ui.view.scoutExplorer.workingSetsOrder".equals(event.getProperty())) && ScoutExplorerSettingsSupport.BundlePresentation.WorkingSet.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                ProjectsTablePage.this.markStructureDirty();
            }
        }
    };
    private final IPropertyChangeListener m_workingSetConfigChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (ScoutExplorerSettingsSupport.BundlePresentation.WorkingSet.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                ProjectsTablePage.this.markStructureDirty();
            }
        }
    };

    public ProjectsTablePage(IPage parent) {
        this.setParent(parent);
        this.setName(Texts.get((String)"RootNodeName"));
        ScoutSdkCore.getScoutWorkspace().addWorkspaceListener(this.m_workspaceListener);
        ScoutSdkUi.getDefault().getPreferenceStore().addPropertyChangeListener(this.m_explorerConfigChangeListener);
        PlatformUI.getWorkbench().getWorkingSetManager().addPropertyChangeListener(this.m_workingSetConfigChangeListener);
    }

    @Override
    public void unloadPage() {
        ScoutSdkCore.getScoutWorkspace().removeWorkspaceListener(this.m_workspaceListener);
        ScoutSdkUi.getDefault().getPreferenceStore().removePropertyChangeListener(this.m_explorerConfigChangeListener);
        PlatformUI.getWorkbench().getWorkingSetManager().removePropertyChangeListener(this.m_workingSetConfigChangeListener);
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.ProjectsTablePage";
    }

    @Override
    public boolean isInitiallyLoaded() {
        return true;
    }

    @Override
    public void refresh(boolean clearCache) {
        if (clearCache) {
            ScoutWorkspace.getInstance().rebuildGraph();
        } else {
            super.refresh(clearCache);
        }
    }

    @Override
    public void loadChildrenImpl() {
        if (ScoutExplorerSettingsSupport.BundlePresentation.Flat.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            IScoutBundle[] allBundles;
            IScoutBundle[] iScoutBundleArray = allBundles = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutExplorerSettingsBundleFilter.get(), ScoutBundleComparators.getSymbolicNameAscComparator());
            int n = allBundles.length;
            int n2 = 0;
            while (n2 < n) {
                IScoutBundle b = iScoutBundleArray[n2];
                ProjectsTablePage.createBundlePage(this, b);
                ++n2;
            }
        } else if (ScoutExplorerSettingsSupport.BundlePresentation.Hierarchical.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            IScoutBundle[] iScoutBundleArray = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getFilteredRootBundlesFilter((IScoutBundleFilter)ScoutExplorerSettingsBundleFilter.get()), ScoutBundleComparators.getSymbolicNameAscComparator());
            int n = iScoutBundleArray.length;
            int b = 0;
            while (b < n) {
                IScoutBundle root = iScoutBundleArray[b];
                ProjectsTablePage.createBundlePage(this, root);
                ++b;
            }
        } else if (ScoutExplorerSettingsSupport.BundlePresentation.WorkingSet.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
            IWorkingSet[] iWorkingSetArray = ScoutExplorerSettingsSupport.get().getScoutWorkingSets(false);
            int n = iWorkingSetArray.length;
            int b = 0;
            while (b < n) {
                IWorkingSet ws = iWorkingSetArray[b];
                new ScoutWorkingSetTablePage(this, ws);
                ++b;
            }
        } else {
            ScoutBundleTreeModel uiModel = new ScoutBundleTreeModel();
            uiModel.build();
            if (ScoutExplorerSettingsSupport.BundlePresentation.FlatGroups.equals((Object)ScoutExplorerSettingsSupport.get().getBundlePresentation())) {
                HashSet<ScoutBundleNodeGroup> collector = new HashSet<ScoutBundleNodeGroup>();
                this.collectAllBundleGroupsRec(collector, uiModel.getRoots());
                for (ScoutBundleNodeGroup g : collector) {
                    new BundleNodeGroupTablePage(this, g);
                }
            } else {
                ScoutBundleNodeGroup[] scoutBundleNodeGroupArray = uiModel.getRoots();
                int n = scoutBundleNodeGroupArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ScoutBundleNodeGroup g = scoutBundleNodeGroupArray[n3];
                    new BundleNodeGroupTablePage(this, g);
                    ++n3;
                }
            }
        }
    }

    private void collectAllBundleGroupsRec(Set<ScoutBundleNodeGroup> collector, ScoutBundleNodeGroup[] groups) {
        ScoutBundleNodeGroup[] scoutBundleNodeGroupArray = groups;
        int n = groups.length;
        int n2 = 0;
        while (n2 < n) {
            ScoutBundleNodeGroup g = scoutBundleNodeGroupArray[n2];
            collector.add(g);
            this.collectAllBundleGroupsRec(collector, g.getChildGroups().toArray(new ScoutBundleNodeGroup[g.getChildGroups().size()]));
            ++n2;
        }
    }

    public static void createBundlePage(IPage parentPage, IScoutBundle b) {
        ScoutBundleUiExtension childExt;
        if (b != null && (childExt = ScoutBundleExtensionPoint.getExtension(b.getType())) != null) {
            ScoutBundleNode rootNode = new ScoutBundleNode(b, childExt);
            rootNode.createBundlePage(parentPage);
        }
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        return new Class[]{ScoutProjectNewAction.class, TypeResolverFormDataAction.class, TypeResolverPageDataAction.class, WellformAction.class};
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof TypeResolverFormDataAction) {
            ((TypeResolverFormDataAction)menu).init(new ITypeResolver(){

                public IType[] getTypes() {
                    IType iForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IForm");
                    IPrimaryTypeTypeHierarchy formHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iForm);
                    return formHierarchy.getAllSubtypes(iForm);
                }
            }, null);
        } else if (menu instanceof TypeResolverPageDataAction) {
            ((TypeResolverPageDataAction)menu).init(new ITypeResolver(){

                public IType[] getTypes() {
                    IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
                    IPrimaryTypeTypeHierarchy pageWithTableHierarchy = TypeUtility.getPrimaryTypeHierarchy((IType)iPageWithTable);
                    return pageWithTableHierarchy.getAllSubtypes(iPageWithTable);
                }
            }, this.getScoutBundle());
        } else if (menu instanceof WellformAction) {
            WellformAction action = (WellformAction)menu;
            IScoutBundle[] clients = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getBundlesOfTypeFilter((String[])new String[]{"CLIENT"}));
            action.setOperation((IOperation)new WellformClientBundleOperation(clients));
            action.init(this.getScoutBundle());
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }
}

