/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project;

import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.scout.sdk.ScoutSdkCore;
import org.eclipse.scout.sdk.extensions.runtime.bundles.RuntimeBundles;
import org.eclipse.scout.sdk.ui.extensions.bundle.ScoutBundleUiExtension;
import org.eclipse.scout.sdk.ui.internal.extensions.bundle.ScoutBundleExtensionPoint;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNode;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutBundleNodeGroup;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.ScoutExplorerSettingsBundleFilter;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.workspace.IScoutBundleFilter;
import org.eclipse.scout.sdk.workspace.ScoutBundleComparators;
import org.eclipse.scout.sdk.workspace.ScoutBundleFilters;

public class ScoutBundleTreeModel {
    private Set<ScoutBundleNodeGroup> m_model;

    public void build() {
        this.m_model = this.buildProjectGraph();
    }

    public ScoutBundleNodeGroup[] getRoots() {
        return this.m_model.toArray(new ScoutBundleNodeGroup[this.m_model.size()]);
    }

    private ScoutBundleNodeGroup createProjects(IScoutBundle bundle, String curType) {
        ScoutBundleUiExtension extension;
        if (curType.equals(bundle.getType()) && ScoutExplorerSettingsBundleFilter.get().accept(bundle) && (extension = ScoutBundleExtensionPoint.getExtension(bundle.getType())) != null) {
            ScoutBundleNodeGroup sbg = new ScoutBundleNodeGroup(new ScoutBundleNode(bundle, extension));
            for (IScoutBundle child : bundle.getDirectChildBundles()) {
                if (!ScoutExplorerSettingsBundleFilter.get().accept(child)) continue;
                ScoutBundleNodeGroup childProject = this.createProjects(child, curType);
                if (childProject == null) {
                    ScoutBundleUiExtension childExt = ScoutBundleExtensionPoint.getExtension(child.getType());
                    if (childExt == null) continue;
                    sbg.addChildBundle(new ScoutBundleNode(child, childExt));
                    continue;
                }
                sbg.addChildGroup(childProject);
            }
            return sbg;
        }
        return null;
    }

    private void removeImplicitChildren(ScoutBundleNodeGroup scoutProject) {
        for (ScoutBundleNode node : scoutProject.getChildBundles()) {
            Iterator<ScoutBundleNode> iterator = node.getChildBundles().iterator();
            while (iterator.hasNext()) {
                ScoutBundleNode childNode = iterator.next();
                if (!scoutProject.containsBundle(childNode)) continue;
                iterator.remove();
            }
        }
        for (ScoutBundleNodeGroup childGroup : scoutProject.getChildGroups()) {
            this.removeImplicitChildren(childGroup);
        }
    }

    private Set<ScoutBundleNodeGroup> buildProjectGraph() {
        TreeSet<ScoutBundleNodeGroup> scoutProjects = new TreeSet<ScoutBundleNodeGroup>();
        String[] types = RuntimeBundles.getTypes();
        int i = types.length - 1;
        while (i >= 0) {
            IScoutBundle[] iScoutBundleArray = ScoutSdkCore.getScoutWorkspace().getBundleGraph().getBundles(ScoutBundleFilters.getFilteredRootBundlesFilter((IScoutBundleFilter)ScoutExplorerSettingsBundleFilter.get()), ScoutBundleComparators.getSymbolicNameAscComparator());
            int n = iScoutBundleArray.length;
            int n2 = 0;
            while (n2 < n) {
                IScoutBundle root = iScoutBundleArray[n2];
                ScoutBundleNodeGroup sbg = this.createProjects(root, types[i]);
                if (sbg != null) {
                    scoutProjects.add(sbg);
                }
                ++n2;
            }
            --i;
        }
        for (ScoutBundleNodeGroup rootGroup : scoutProjects) {
            this.removeImplicitChildren(rootGroup);
        }
        return scoutProjects;
    }
}

