/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.tree;

import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.sdk.ui.action.IScoutHandler;
import org.eclipse.scout.sdk.ui.action.delete.MemberListDeleteAction;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.KeyStrokeTablePage;
import org.eclipse.scout.sdk.ui.internal.view.outline.pages.project.client.MenuTablePage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractPage;
import org.eclipse.scout.sdk.ui.view.outline.pages.AbstractScoutTypePage;

public class TreeNodePage
extends AbstractScoutTypePage {
    private final boolean m_hasDeleteAction;

    public TreeNodePage(AbstractPage parent, IType type) {
        this(parent, type, false);
    }

    public TreeNodePage(AbstractPage parent, IType type, boolean hasDeleteAction) {
        this.m_hasDeleteAction = hasDeleteAction;
        this.setParent(parent);
        this.setType(type);
        this.setImageDescriptor(ScoutSdkUi.getImageDescriptor("tree.gif"));
    }

    @Override
    public String getPageId() {
        return "org.eclipse.scout.sdk.page.TreeNodePage";
    }

    @Override
    protected String getMethodNameForTranslatedText() {
        return "getConfiguredTitle";
    }

    @Override
    protected void loadChildrenImpl() {
        new KeyStrokeTablePage(this, this.getType());
        new MenuTablePage(this, this.getType());
    }

    @Override
    public Class<? extends IScoutHandler>[] getSupportedMenuActions() {
        if (this.m_hasDeleteAction) {
            return new Class[]{MemberListDeleteAction.class};
        }
        return null;
    }

    @Override
    public void prepareMenuAction(IScoutHandler menu) {
        super.prepareMenuAction(menu);
        if (menu instanceof MemberListDeleteAction) {
            MemberListDeleteAction action = (MemberListDeleteAction)menu;
            action.addMemberToDelete((IMember)this.getType());
            action.setImage(ScoutSdkUi.getImageDescriptor("tree_add.gif"));
        }
    }
}

