/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.internal.view.properties.presenter.single;

import java.text.DecimalFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ui.view.properties.presenter.single.AbstractValuePresenter;
import org.eclipse.scout.sdk.workspace.type.config.ConfigPropertyUpdateOperation;
import org.eclipse.scout.sdk.workspace.type.config.parser.IPropertySourceParser;
import org.eclipse.scout.sdk.workspace.type.config.parser.LongPropertySourceParser;
import org.eclipse.swt.widgets.Composite;

public class LongPresenter
extends AbstractValuePresenter<Long> {
    private final IPropertySourceParser<Long> m_parser = new LongPropertySourceParser();

    public LongPresenter(PropertyViewFormToolkit toolkit, Composite parent) {
        super(toolkit, parent, "[-+0-9\\'Eeinfl]*");
    }

    public IPropertySourceParser<Long> getParser() {
        return this.m_parser;
    }

    @Override
    protected String formatDisplayValue(Long value) throws CoreException {
        if (value == null) {
            return "";
        }
        if (value == Long.MAX_VALUE) {
            return "inf";
        }
        if (value == Long.MIN_VALUE) {
            return "-inf";
        }
        return DecimalFormat.getNumberInstance().format(value);
    }

    @Override
    protected Long parseSourceInput(String input) throws CoreException {
        return this.parseDisplayInput(input);
    }

    @Override
    protected Long parseDisplayInput(String input) throws CoreException {
        if (input.equals("")) {
            return (Long)this.getDefaultValue();
        }
        return (Long)this.getParser().parseSourceValue(input, this.getMethod().peekMethod(), this.getMethod().getSuperTypeHierarchy());
    }

    @Override
    protected synchronized void storeValue(Long value) throws CoreException {
        try {
            ConfigPropertyUpdateOperation updateOp = new ConfigPropertyUpdateOperation(this.getMethod(), this.getParser());
            updateOp.setValue((Object)value);
            OperationJob job = new OperationJob(new IOperation[]{updateOp});
            job.setDebug(true);
            job.schedule();
        }
        catch (Exception e) {
            ScoutSdkUi.logError("could not parse default value of method '" + this.getMethod().getMethodName() + "' in type '" + this.getMethod().getType().getFullyQualifiedName() + "'.", e);
        }
    }

    @Override
    protected int getTextAlignment() {
        return 131072;
    }
}

