/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.AbstractJavaElementContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.SearchFormNewWizard;
import org.eclipse.scout.sdk.util.NamingUtility;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SearchFormNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_NLS_NAME = "nlsName";
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TABLE_PAGE = "tablePage";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    private final IType iSearchForm = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm");
    private ProposalTextField m_nlsNameField;
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private ProposalTextField m_tablePageField;
    private EntityTextField m_entityField;
    private final IScoutBundle m_clientBundle;
    private IType m_abstractSearchForm;

    public SearchFormNewWizardPage(IScoutBundle clientBundle) {
        super(SearchFormNewWizardPage.class.getName());
        this.m_clientBundle = clientBundle;
        this.setTitle(Texts.get((String)"SearchForm2"));
        this.setDescription(Texts.get((String)"CreateANewSearchForm"));
        if (clientBundle != null) {
            this.m_abstractSearchForm = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm", (IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)clientBundle));
            this.setSuperTypeInternal(this.m_abstractSearchForm);
            this.setTargetPackage(DefaultTargetPackage.get((IScoutBundle)clientBundle, (String)"client.searchform"));
        }
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        boolean isEnabled = this.getClientBundle() != null;
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"SearchForm"));
        INlsProject nls = null;
        if (this.getClientBundle() != null) {
            nls = this.getClientBundle().getNlsProject();
        }
        this.m_nlsNameField = this.getFieldToolkit().createNlsProposalTextField((Composite)group, nls, Texts.get((String)"PropTitle"), labelColWidthPercent);
        this.m_nlsNameField.acceptProposal(this.getNlsName());
        this.m_nlsNameField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                try {
                    SearchFormNewWizardPage.this.setStateChanging(true);
                    INlsEntry oldEntry = SearchFormNewWizardPage.this.getNlsName();
                    INlsEntry newName = (INlsEntry)event.proposal;
                    SearchFormNewWizardPage.this.setNlsNameInternal(newName);
                    if (newName != null && (oldEntry == null || StringUtility.isNullOrEmpty((String)SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()) || oldEntry.getKey().equals(SearchFormNewWizardPage.this.m_typeNameField.getModifiableText()))) {
                        SearchFormNewWizardPage.this.m_typeNameField.setText(NamingUtility.toJavaCamelCase((String)newName.getKey(), (boolean)false));
                    }
                }
                finally {
                    SearchFormNewWizardPage.this.setStateChanging(false);
                }
            }
        });
        this.m_nlsNameField.setEnabled(isEnabled);
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField((Composite)group, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix("SearchForm");
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchFormNewWizardPage.this.setTypeNameInternal(SearchFormNewWizardPage.this.m_typeNameField.getText());
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_typeNameField.setEnabled(isEnabled);
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iSearchForm, ScoutUtility.getJavaProject((IScoutBundle)this.getClientBundle()), this.m_abstractSearchForm), labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField.setEnabled(isEnabled);
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField((Composite)group, Texts.get((String)"EntityTextField"), this.getClientBundle(), labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage(null));
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    SearchFormNewWizardPage.this.setTargetPackageInternal(SearchFormNewWizardPage.this.m_entityField.getText());
                    SearchFormNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
            this.m_entityField.setEnabled(isEnabled);
        }
        Control tablePageGroup = this.createTablePageGroup(parent, labelColWidthPercent);
        parent.setLayout((Layout)new GridLayout(1, true));
        group.setLayout((Layout)new GridLayout(1, true));
        group.setLayoutData((Object)new GridData(768));
        tablePageGroup.setLayoutData((Object)new GridData(768));
        this.m_nlsNameField.setLayoutData(new GridData(768));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_nlsNameField.setFocus();
    }

    private Control createTablePageGroup(Composite parent, int labelColWidthPercent) {
        Group group = new Group(parent, 16);
        group.setText(Texts.get((String)"AutoCreate"));
        Label label = new Label((Composite)group, 0);
        label.setText(Texts.get((String)"SelectTablePageForSearchForm"));
        this.m_tablePageField = this.getFieldToolkit().createJavaElementProposalField((Composite)group, Texts.get((String)"TablePage"), new AbstractJavaElementContentProvider(){

            @Override
            protected Object[][] computeProposals() {
                IType iPage = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPage");
                IType iPageWithTable = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable");
                IType[] list = TypeUtility.getPrimaryTypeHierarchy((IType)iPage).getAllSubtypes(iPageWithTable, TypeFilters.getTypesOnClasspath((IJavaProject)ScoutUtility.getJavaProject((IScoutBundle)SearchFormNewWizardPage.this.getClientBundle())), TypeComparators.getTypeNameComparator());
                return new Object[][]{list};
            }
        }, labelColWidthPercent);
        this.m_tablePageField.acceptProposal(this.getTablePageType());
        this.m_tablePageField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                SearchFormNewWizardPage.this.setTablePageTypeInternal((IType)event.proposal);
                SearchFormNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_tablePageField.setEnabled(this.getClientBundle() != null);
        group.setLayout((Layout)new GridLayout(1, true));
        label.setLayoutData((Object)new GridData(768));
        this.m_tablePageField.setLayoutData(new GridData(768));
        return group;
    }

    @Override
    public void setFocus() {
        if (this.m_tablePageField.getSelectedProposal() == null) {
            this.m_tablePageField.setFocus();
        } else {
            this.m_nlsNameField.setFocus();
        }
    }

    public SearchFormNewWizard getWizard() {
        return (SearchFormNewWizard)super.getWizard();
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        multiStatus.add(this.getStatusWorkspace());
        multiStatus.add(this.getStatusNameField());
        multiStatus.add(this.getStatusSuperType());
        multiStatus.add(this.getStatusTargetPackge());
    }

    protected IStatus getStatusWorkspace() {
        if (this.getClientBundle() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"NoNewXWithoutScoutBundle", (String[])new String[]{Texts.get((String)"SearchForm")}));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetPackge() {
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            return ScoutUtility.validatePackageName((String)this.getTargetPackage(null));
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusNameField() {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"SearchForm");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.getClientBundle(), (String)this.getTargetPackage("client.searchform"), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IScoutBundle getClientBundle() {
        return this.m_clientBundle;
    }

    public INlsEntry getNlsName() {
        return (INlsEntry)this.getProperty(PROP_NLS_NAME);
    }

    public void setNlsName(INlsEntry proposal) {
        try {
            this.setStateChanging(true);
            this.setNlsNameInternal(proposal);
            if (this.isControlCreated()) {
                this.m_nlsNameField.acceptProposal(proposal);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setNlsNameInternal(INlsEntry proposal) {
        this.setProperty(PROP_NLS_NAME, proposal);
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public IType getTablePageType() {
        return (IType)this.getProperty(PROP_TABLE_PAGE);
    }

    public void setTablePageType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setTablePageTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_tablePageField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    private void setTablePageTypeInternal(IType superType) {
        this.setProperty(PROP_TABLE_PAGE, superType);
    }

    public String getTargetPackage(String packageId) {
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            return (String)this.getProperty(PROP_TARGET_PACKAGE);
        }
        return DefaultTargetPackage.get(null, (String)packageId);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }
}

