/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.form.handler;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.ui.fields.table.FilteredTable;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ui.wizard.form.handler.FormHandlerNewWizardPage2;
import org.eclipse.scout.sdk.util.type.TypeComparators;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormHandlerNewWizardPage1
extends AbstractWorkspaceWizardPage {
    private final IType iFormHandler = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler");
    private IType m_declaringType;
    private boolean m_showAllTemplates;
    private FilteredTable m_filteredTable;
    private Button m_showAllTemplatesField;
    private HandlerTemplate m_selectedTemplate;

    public FormHandlerNewWizardPage1(IType declaringType) {
        super(FormHandlerNewWizardPage1.class.getName());
        this.setTitle(Texts.get((String)"FormHandlerTemplates"));
        this.setDescription(Texts.get((String)"ChooseATemplateForYourFormHandler"));
        this.m_declaringType = declaringType;
    }

    @Override
    protected void createContent(Composite parent) {
        IType[] abstractFormHandlers;
        this.m_filteredTable = new FilteredTable(parent, 68100);
        this.m_filteredTable.getViewer().addFilter((ViewerFilter)new P_ModeFilter());
        this.m_filteredTable.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    StructuredSelection selection = (StructuredSelection)event.getSelection();
                    FormHandlerNewWizardPage1.this.m_selectedTemplate = (HandlerTemplate)selection.getFirstElement();
                    FormHandlerNewWizardPage1.this.validateNextPage();
                    FormHandlerNewWizardPage1.this.pingStateChanging();
                }
            }
        });
        ArrayList<HandlerTemplate> templates = new ArrayList<HandlerTemplate>();
        IType formHandler = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.form.IFormHandler", (IJavaProject)this.m_declaringType.getJavaProject());
        templates.add(new HandlerTemplate(Texts.get((String)"FormHandlerNEW"), formHandler, 1));
        templates.add(new HandlerTemplate(Texts.get((String)"FormHandlerMODIFY"), formHandler, 2));
        templates.add(new HandlerTemplate(Texts.get((String)"FormHandler"), formHandler, 3));
        IType[] iTypeArray = abstractFormHandlers = TypeUtility.getPrimaryTypeHierarchy((IType)this.iFormHandler).getAllSubtypes(this.iFormHandler, TypeFilters.getAbstractOnClasspath((IJavaProject)this.m_declaringType.getJavaProject()), TypeComparators.getTypeNameComparator());
        int n = abstractFormHandlers.length;
        int n2 = 0;
        while (n2 < n) {
            IType t = iTypeArray[n2];
            templates.add(new HandlerTemplate(t.getElementName(), t, 4));
            ++n2;
        }
        P_TableContentProvider provider = new P_TableContentProvider(templates.toArray(new HandlerTemplate[templates.size()]));
        this.m_filteredTable.getViewer().setLabelProvider((IBaseLabelProvider)provider);
        this.m_filteredTable.getViewer().setContentProvider((IContentProvider)provider);
        this.m_filteredTable.getViewer().setInput((Object)provider);
        this.m_showAllTemplatesField = new Button(parent, 32);
        this.m_showAllTemplatesField.setSelection(false);
        this.m_showAllTemplatesField.setText(Texts.get((String)"ShowAllTemplates"));
        this.m_showAllTemplatesField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    FormHandlerNewWizardPage1.this.setStateChanging(true);
                    FormHandlerNewWizardPage1.this.setShowAllTemplates(FormHandlerNewWizardPage1.this.m_showAllTemplatesField.getSelection());
                }
                finally {
                    FormHandlerNewWizardPage1.this.setStateChanging(false);
                }
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_filteredTable.setLayoutData(new GridData(1808));
    }

    protected void validateNextPage() {
        FormHandlerNewWizardPage2 nextPage = (FormHandlerNewWizardPage2)this.getWizard().getNextPage((IWizardPage)this);
        if (this.m_selectedTemplate == null || this.m_selectedTemplate.getId() == 3 || this.m_selectedTemplate.getId() == 3) {
            nextPage.setTypeName("");
        } else {
            switch (this.m_selectedTemplate.getId()) {
                case 2: {
                    nextPage.setTypeName("Modify");
                    break;
                }
                case 1: {
                    nextPage.setTypeName("New");
                }
            }
        }
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        if (this.m_selectedTemplate != null) {
            multiStatus.add(Status.OK_STATUS);
        } else {
            multiStatus.add((IStatus)new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"ATemplateMustBeSelected")));
        }
    }

    public void setSuperType(IType selectedType) {
        IStructuredContentProvider prov = (IStructuredContentProvider)this.m_filteredTable.getViewer().getContentProvider();
        Object[] objectArray = prov.getElements(null);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object row = objectArray[n2];
            if (((HandlerTemplate)row).getType().equals(selectedType)) {
                this.m_filteredTable.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedType));
            }
            ++n2;
        }
        this.validateNextPage();
    }

    public boolean isShowAllTemplates() {
        return this.m_showAllTemplates;
    }

    public void setShowAllTemplates(boolean showAllTemplates) {
        try {
            this.setStateChanging(true);
            this.m_showAllTemplates = showAllTemplates;
            if (this.isControlCreated()) {
                this.m_showAllTemplatesField.setSelection(showAllTemplates);
                this.m_filteredTable.getViewer().refresh();
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSelectedSuperType() {
        return this.m_selectedTemplate.getType();
    }

    private class HandlerTemplate {
        public static final int ID_NEW = 1;
        public static final int ID_MODIFY = 2;
        public static final int ID_CUSTOM = 3;
        public static final int ID_DEFAULT = 4;
        private final IType m_type;
        private final String m_templateName;
        private final int m_id;

        public HandlerTemplate(String templateName, IType type, int id) {
            this.m_templateName = templateName;
            this.m_type = type;
            this.m_id = id;
        }

        public IType getType() {
            return this.m_type;
        }

        public String getTemplateName() {
            return this.m_templateName;
        }

        public int getId() {
            return this.m_id;
        }
    }

    private class P_ModeFilter
    extends ViewerFilter {
        private P_ModeFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (FormHandlerNewWizardPage1.this.m_showAllTemplates) {
                return ((HandlerTemplate)element).getId() == 4;
            }
            return ((HandlerTemplate)element).getId() != 4;
        }
    }

    private class P_TableContentProvider
    implements IStructuredContentProvider,
    ITableLabelProvider {
        HandlerTemplate[] m_templates;

        private P_TableContentProvider(HandlerTemplate[] templates) {
            this.m_templates = templates;
        }

        public Object[] getElements(Object inputElement) {
            return this.m_templates;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ScoutSdkUi.getImage("formField.png");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((HandlerTemplate)element).getTemplateName();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

