/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.keystroke;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.runtime.classes.RuntimeClasses;
import org.eclipse.scout.sdk.operation.KeyStrokeNewOperation;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.type.IStructuredType;
import org.eclipse.scout.sdk.workspace.type.ScoutTypeUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class KeyStrokeNewWizardPage
extends AbstractWorkspaceWizardPage {
    private final IType iKeyStroke = TypeUtility.getType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke");
    private String m_typeName;
    private IType m_superType;
    private String m_keyStroke;
    private StyledTextField m_typeNameField;
    private StyledTextField m_keyStrokeField;
    private ProposalTextField m_superTypeField;
    private final IType m_declaringType;
    private IType m_createdKeystroke;
    private final IType m_abstractKeyStroke;

    public KeyStrokeNewWizardPage(IType declaringType) {
        super(KeyStrokeNewWizardPage.class.getName());
        this.setTitle(Texts.get((String)"NewKeyStroke"));
        this.setDescription(Texts.get((String)"CreateANewKeyStroke"));
        this.m_declaringType = declaringType;
        this.m_superType = this.m_abstractKeyStroke = RuntimeClasses.getSuperType((String)"org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke", (IJavaProject)this.m_declaringType.getJavaProject());
    }

    @Override
    protected void createContent(Composite parent) {
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"));
        this.m_typeNameField.setReadOnlySuffix("KeyStroke");
        this.m_typeNameField.setText(this.m_typeName);
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyStrokeNewWizardPage.this.m_typeName = KeyStrokeNewWizardPage.this.m_typeNameField.getText();
                KeyStrokeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), new JavaElementAbstractTypeContentProvider(this.iKeyStroke, this.m_declaringType.getJavaProject(), this.m_abstractKeyStroke));
        this.m_superTypeField.acceptProposal(this.m_superType);
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                KeyStrokeNewWizardPage.this.m_superType = (IType)event.proposal;
                KeyStrokeNewWizardPage.this.pingStateChanging();
            }
        });
        this.m_keyStrokeField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"KeyStroke"));
        this.m_keyStrokeField.setText(this.getKeyStroke());
        this.m_keyStrokeField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                KeyStrokeNewWizardPage.this.m_keyStroke = KeyStrokeNewWizardPage.this.m_keyStrokeField.getText();
                KeyStrokeNewWizardPage.this.pingStateChanging();
            }
        });
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
        this.m_keyStrokeField.setLayoutData(new GridData(768));
    }

    @Override
    public boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        KeyStrokeNewOperation op = new KeyStrokeNewOperation(this.getTypeName(), this.getDeclaringType());
        IType superTypeProp = this.getSuperType();
        if (superTypeProp != null) {
            op.setSuperTypeSignature(SignatureCache.createTypeSignature((String)superTypeProp.getFullyQualifiedName()));
        }
        op.setKeyStroke(this.getKeyStroke());
        IStructuredType structuredType = ScoutTypeUtility.createStructuredForm((IType)this.m_declaringType);
        op.setSibling(structuredType.getSiblingTypeKeyStroke(this.getTypeName()));
        op.run(monitor, workingCopyManager);
        this.m_createdKeystroke = op.getCreatedKeyStroke();
        return true;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)"KeyStroke");
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        if (TypeUtility.exists((IJavaElement)this.getDeclaringType().getType(this.getTypeName()))) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"Error_nameAlreadyUsed"));
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public IType getCreatedKeystroke() {
        return this.m_createdKeystroke;
    }

    public IType getDeclaringType() {
        return this.m_declaringType;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.m_typeName = typeName;
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.m_superType = superType;
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public void setKeyStroke(String keyStroke) {
        try {
            this.setStateChanging(true);
            this.m_keyStroke = keyStroke;
            if (this.isControlCreated()) {
                this.m_keyStrokeField.setText(keyStroke);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    public String getKeyStroke() {
        return this.m_keyStroke;
    }
}

