/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ui.wizard.services;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.scout.sdk.Texts;
import org.eclipse.scout.sdk.extensions.targetpackage.DefaultTargetPackage;
import org.eclipse.scout.sdk.ui.fields.StyledTextField;
import org.eclipse.scout.sdk.ui.fields.javacode.EntityTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.ContentProposalEvent;
import org.eclipse.scout.sdk.ui.fields.proposal.IProposalAdapterListener;
import org.eclipse.scout.sdk.ui.fields.proposal.ProposalTextField;
import org.eclipse.scout.sdk.ui.fields.proposal.javaelement.JavaElementAbstractTypeContentProvider;
import org.eclipse.scout.sdk.ui.fields.proposal.signature.SignatureSubTypeProposalProvider;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.util.ScoutUtility;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeFilters;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ServiceNewWizardPage
extends AbstractWorkspaceWizardPage {
    public static final String PROP_TYPE_NAME = "typeName";
    public static final String PROP_SUPER_TYPE = "superType";
    public static final String PROP_TARGET_PACKAGE = "targetPackage";
    public static final String PROP_GENERIC_TYPE = "genericType";
    private StyledTextField m_typeNameField;
    private ProposalTextField m_superTypeField;
    private EntityTextField m_entityField;
    private ProposalTextField m_genericTypeField;
    private final IType m_definitionType;
    private final String m_typeNameSuffix;
    private final IScoutBundle m_bundle;

    public ServiceNewWizardPage(String title, String message, IType definitionType, String typeNameSuffix, IScoutBundle b, String defaultPackage) {
        super(ServiceNewWizardPage.class.getName());
        this.m_typeNameSuffix = typeNameSuffix;
        this.m_definitionType = definitionType;
        this.m_bundle = b;
        this.setTargetPackage(defaultPackage);
        this.setTitle(title);
        this.setDescription(message);
    }

    private String getTypeParamName() {
        if (TypeUtility.isGenericType((IType)this.m_definitionType)) {
            try {
                return this.m_definitionType.getTypeParameters()[0].getElementName();
            }
            catch (JavaModelException e1) {
                ScoutSdkUi.logError(e1);
            }
        }
        return null;
    }

    @Override
    protected void createContent(Composite parent) {
        int labelColWidthPercent = 20;
        this.m_typeNameField = this.getFieldToolkit().createStyledTextField(parent, Texts.get((String)"TypeName"), labelColWidthPercent);
        this.m_typeNameField.setReadOnlySuffix(this.getTypeNameSuffix());
        this.m_typeNameField.setText(this.getTypeName());
        this.m_typeNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServiceNewWizardPage.this.setTypeNameInternal(ServiceNewWizardPage.this.m_typeNameField.getText());
                ServiceNewWizardPage.this.pingStateChanging();
            }
        });
        final boolean isGenericDefType = TypeUtility.isGenericType((IType)this.m_definitionType);
        ITypeFilter filter = null;
        String typeParamName = this.getTypeParamName();
        if (typeParamName != null) {
            filter = TypeFilters.getTypeParamSubTypeFilter((String)this.getGenericTypeSignature(), (String)this.m_definitionType.getFullyQualifiedName(), (String)typeParamName);
        }
        final JavaElementAbstractTypeContentProvider contentProvider = new JavaElementAbstractTypeContentProvider(this.m_definitionType, this.m_bundle.getJavaProject(), filter, this.getSuperType());
        SignatureSubTypeProposalProvider tmpProposalProvider = null;
        if (isGenericDefType) {
            tmpProposalProvider = new SignatureSubTypeProposalProvider(this.getGenericTypeOfSuperClass(), this.m_bundle.getJavaProject());
        }
        final SignatureSubTypeProposalProvider keyTypeProposalProvider = tmpProposalProvider;
        this.m_superTypeField = this.getFieldToolkit().createJavaElementProposalField(parent, Texts.get((String)"SuperType"), contentProvider, labelColWidthPercent);
        this.m_superTypeField.acceptProposal(this.getSuperType());
        this.m_superTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

            @Override
            public void proposalAccepted(ContentProposalEvent event) {
                ServiceNewWizardPage.this.setSuperTypeInternal((IType)event.proposal);
                if (isGenericDefType) {
                    IType genericTypeOfSuperClass = ServiceNewWizardPage.this.getGenericTypeOfSuperClass();
                    if (ServiceNewWizardPage.this.getGenericTypeSignature() == null && TypeUtility.exists((IJavaElement)genericTypeOfSuperClass)) {
                        ServiceNewWizardPage.this.m_genericTypeField.acceptProposal(SignatureCache.createTypeSignature((String)genericTypeOfSuperClass.getFullyQualifiedName()));
                    }
                    if (keyTypeProposalProvider != null) {
                        keyTypeProposalProvider.setBaseType(genericTypeOfSuperClass);
                    }
                }
                ServiceNewWizardPage.this.pingStateChanging();
            }
        });
        if (DefaultTargetPackage.isPackageConfigurationEnabled()) {
            this.m_entityField = this.getFieldToolkit().createEntityTextField(parent, Texts.get((String)"EntityTextField"), this.m_bundle, labelColWidthPercent);
            this.m_entityField.setText(this.getTargetPackage());
            this.m_entityField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ServiceNewWizardPage.this.setTargetPackageInternal(ServiceNewWizardPage.this.m_entityField.getText());
                    ServiceNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_entityField.setLayoutData(new GridData(768));
        }
        if (isGenericDefType && keyTypeProposalProvider != null) {
            this.m_genericTypeField = this.getFieldToolkit().createProposalField(parent, Texts.get((String)"KeyType"), 1, labelColWidthPercent);
            this.m_genericTypeField.setContentProvider(keyTypeProposalProvider);
            this.m_genericTypeField.setLabelProvider((IBaseLabelProvider)keyTypeProposalProvider.getLabelProvider());
            this.m_genericTypeField.acceptProposal(this.getGenericTypeSignature());
            this.m_genericTypeField.addProposalAdapterListener(new IProposalAdapterListener(){

                @Override
                public void proposalAccepted(ContentProposalEvent event) {
                    ServiceNewWizardPage.this.setGenericTypeSignatureInternal((String)event.proposal);
                    contentProvider.invalidateCache();
                    ServiceNewWizardPage.this.pingStateChanging();
                }
            });
            this.m_genericTypeField.setLayoutData(new GridData(768));
        }
        parent.setLayout((Layout)new GridLayout(1, true));
        this.m_typeNameField.setLayoutData(new GridData(768));
        this.m_superTypeField.setLayoutData(new GridData(768));
    }

    protected IType getGenericTypeOfSuperClass() {
        if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
            ITypeParameter[] typeParameters = TypeUtility.getTypeParameters((IType)this.m_definitionType);
            try {
                String typeParamSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.getSuperType(), (ITypeHierarchy)this.getSuperType().newSupertypeHierarchy(null), (String)this.m_definitionType.getFullyQualifiedName(), (String)typeParameters[0].getElementName());
                if (typeParamSig != null) {
                    return TypeUtility.getTypeBySignature((String)typeParamSig);
                }
            }
            catch (CoreException e) {
                ScoutSdkUi.logError(e);
            }
        }
        return null;
    }

    @Override
    protected void validatePage(MultiStatus multiStatus) {
        try {
            multiStatus.add(this.getStatusNameField());
            multiStatus.add(this.getStatusSuperType());
            multiStatus.add(this.getStatusTargetPackge());
            multiStatus.add(this.getStatusGenericType());
        }
        catch (JavaModelException e) {
            ScoutSdkUi.logError("could not validate name field.", e);
        }
    }

    protected IStatus getStatusGenericType() {
        if (this.m_genericTypeField != null) {
            if (this.getGenericTypeSignature() == null) {
                return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeCanNotBeNull"));
            }
            if (TypeUtility.exists((IJavaElement)this.getSuperType())) {
                try {
                    String typeParamSig = SignatureUtility.resolveGenericParameterInSuperHierarchy((IType)this.getSuperType(), (ITypeHierarchy)this.getSuperType().newSupertypeHierarchy(null), (String)this.m_definitionType.getFullyQualifiedName(), (String)this.getTypeParamName());
                    if (typeParamSig != null) {
                        IType generic = TypeUtility.getTypeBySignature((String)this.getGenericTypeSignature());
                        IType superType = TypeUtility.getTypeBySignature((String)typeParamSig);
                        if (TypeUtility.exists((IJavaElement)generic) && !TypeUtility.getSuperTypeHierarchy((IType)generic).contains(superType)) {
                            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"GenericTypeDoesNotMatchSuperClass"));
                        }
                    }
                }
                catch (CoreException e) {
                    ScoutSdkUi.logError(e);
                    return new Status(4, "org.eclipse.scout.sdk.ui", "Unknown Error. See Error Log View for Details");
                }
            }
        }
        return Status.OK_STATUS;
    }

    protected IStatus getStatusTargetPackge() {
        return ScoutUtility.validatePackageName((String)this.getTargetPackage());
    }

    protected IStatus getStatusNameField() throws JavaModelException {
        IStatus javaFieldNameStatus = ScoutUtility.validateJavaName((String)this.getTypeName(), (String)this.getTypeNameSuffix());
        if (javaFieldNameStatus.getSeverity() > 2) {
            return javaFieldNameStatus;
        }
        IStatus existingStatus = ScoutUtility.validateTypeNotExisting((IScoutBundle)this.m_bundle, (String)this.getTargetPackage(), (String)this.getTypeName());
        if (!existingStatus.isOK()) {
            return existingStatus;
        }
        return javaFieldNameStatus;
    }

    protected IStatus getStatusSuperType() throws JavaModelException {
        if (this.getSuperType() == null) {
            return new Status(4, "org.eclipse.scout.sdk.ui", Texts.get((String)"TheSuperTypeCanNotBeNull"));
        }
        return Status.OK_STATUS;
    }

    public String getTypeNameSuffix() {
        return this.m_typeNameSuffix;
    }

    public String getTypeName() {
        return this.getPropertyString(PROP_TYPE_NAME);
    }

    public void setTypeName(String typeName) {
        try {
            this.setStateChanging(true);
            this.setTypeNameInternal(typeName);
            if (this.isControlCreated()) {
                this.m_typeNameField.setText(typeName);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTypeNameInternal(String typeName) {
        this.setPropertyString(PROP_TYPE_NAME, typeName);
    }

    public IType getSuperType() {
        return (IType)this.getProperty(PROP_SUPER_TYPE);
    }

    public void setSuperType(IType superType) {
        try {
            this.setStateChanging(true);
            this.setSuperTypeInternal(superType);
            if (this.isControlCreated()) {
                this.m_superTypeField.acceptProposal(superType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setSuperTypeInternal(IType superType) {
        this.setProperty(PROP_SUPER_TYPE, superType);
    }

    public String getTargetPackage() {
        return (String)this.getProperty(PROP_TARGET_PACKAGE);
    }

    public void setTargetPackage(String targetPackage) {
        try {
            this.setStateChanging(true);
            this.setTargetPackageInternal(targetPackage);
            if (this.isControlCreated() && this.m_entityField != null) {
                this.m_entityField.setText(targetPackage);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setTargetPackageInternal(String targetPackage) {
        this.setProperty(PROP_TARGET_PACKAGE, targetPackage);
    }

    public String getGenericTypeSignature() {
        return (String)this.getProperty(PROP_GENERIC_TYPE);
    }

    public void setGenericTypeSignature(String genericType) {
        try {
            this.setStateChanging(true);
            this.setGenericTypeSignatureInternal(genericType);
            if (this.isControlCreated() && this.m_genericTypeField != null) {
                this.m_genericTypeField.acceptProposal(genericType);
            }
        }
        finally {
            this.setStateChanging(false);
        }
    }

    protected void setGenericTypeSignatureInternal(String genericType) {
        this.setProperty(PROP_GENERIC_TYPE, genericType);
    }
}

