/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.ast;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.ast.VariableType;
import org.eclipse.scout.sdk.util.ast.visitor.TypeSignatureResolveVisitor;
import org.eclipse.scout.sdk.util.ast.visitor.VariableResolveVisitor;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public final class AstUtility {
    private AstUtility() {
    }

    public static VariableType getTypeSignature(ASTNode node, ASTNode rootNode, IJavaElement containerElement) {
        TypeSignatureResolveVisitor visitor = new TypeSignatureResolveVisitor(rootNode, containerElement);
        node.accept((ASTVisitor)visitor);
        VariableType var = new VariableType("");
        var.setTypeSignature(visitor.getTypeSignature());
        var.addAssignedSignatures(visitor.getAssignedSignatures());
        return var;
    }

    public static VariableType resolveVariable(String variableName, IJavaElement containerElement, ASTNode rootNode, ASTNode stopNode) {
        VariableResolveVisitor visitor = new VariableResolveVisitor(variableName, containerElement, rootNode, stopNode);
        rootNode.accept((ASTVisitor)visitor);
        VariableType var = new VariableType(variableName);
        var.addAssignedSignatures(visitor.getAssignedTypesSignatures());
        var.setTypeSignature(visitor.getVariableTypeSignature());
        return var;
    }

    public static void visitMember(IMember member, ASTVisitor visitor) {
        AstUtility.visitMember(member, visitor, null);
    }

    public static void visitMember(IMember member, ASTVisitor visitor, IProgressMonitor monitor) {
        ISourceRange r = null;
        try {
            r = member.getSourceRange();
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("Could not calculate source range for member '" + member.toString() + "'.", e);
        }
        ASTParser parser = AstUtility.newParser();
        parser.setKind(8);
        parser.setCompilerOptions(member.getJavaProject().getOptions(true));
        parser.setIgnoreMethodBodies(false);
        if (r != null && r.getOffset() >= 0) {
            parser.setSourceRange(r.getOffset(), r.getLength());
        }
        parser.setResolveBindings(true);
        if (member.isBinary()) {
            parser.setSource(member.getClassFile());
        } else {
            parser.setSource(member.getCompilationUnit());
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ASTNode ast = parser.createAST(monitor);
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        ast.accept(visitor);
    }

    public static ASTParser newParser() {
        return ASTParser.newParser((int)AstUtility.getLatestAstApiLevel());
    }

    public static int getLatestAstApiLevel() {
        int result = 4;
        try {
            String fieldNamePrefix = "JLS";
            int apiLevel = 8;
            Field declaredField = AST.class.getDeclaredField(String.valueOf(fieldNamePrefix) + apiLevel);
            while (declaredField != null && Integer.TYPE.equals(declaredField.getType())) {
                result = declaredField.getInt(null);
                declaredField = AST.class.getDeclaredField(String.valueOf(fieldNamePrefix) + ++apiLevel);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static String resolveReturnValueSignature(String typeSignature, String methodName) {
        try {
            IMethod method;
            IType refType;
            if (!StringUtility.isNullOrEmpty((String)typeSignature) && TypeUtility.exists((IJavaElement)(refType = TypeUtility.getTypeBySignature(typeSignature))) && TypeUtility.exists((IJavaElement)(method = TypeUtility.getMethod(refType, methodName)))) {
                return SignatureUtility.getResolvedSignature(method.getReturnType(), refType);
            }
        }
        catch (CoreException e) {
            SdkUtilActivator.logError("could not parse return type of method '" + methodName + "' on type '" + typeSignature + "'");
        }
        return null;
    }
}

