/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.internal.typecache;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.util.type.ITypeFilter;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class TypeHierarchy
implements org.eclipse.scout.sdk.util.typecache.ITypeHierarchy {
    private ITypeHierarchy m_hierarchy;
    private final IType m_type;

    TypeHierarchy(IType type) {
        this(type, null);
    }

    TypeHierarchy(IType type, ITypeHierarchy jdtHierarchy) {
        this.setJdtHierarchy(jdtHierarchy);
        this.m_type = type;
    }

    @Override
    public ITypeHierarchy getJdtHierarchy() {
        return this.m_hierarchy;
    }

    protected void setJdtHierarchy(ITypeHierarchy hierarchy) {
        this.m_hierarchy = hierarchy;
    }

    @Override
    public boolean contains(IType type) {
        return this.contains(type, null);
    }

    public boolean contains(IType type, IProgressMonitor monitor) {
        this.revalidate(monitor);
        return TypeUtility.exists((IJavaElement)type) && this.m_hierarchy.contains(type);
    }

    void revalidate(IProgressMonitor monitor) {
    }

    @Override
    public IType getType() {
        return this.m_type;
    }

    @Override
    public IType[] getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public IType[] getAllClasses(ITypeFilter filter) {
        return this.getAllClasses(filter, null);
    }

    @Override
    public IType[] getAllClasses(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] classes = this.m_hierarchy.getAllClasses();
        return TypeHierarchy.getTypesFilteredAndSorted(classes, filter, comparator);
    }

    @Override
    public IType[] getAllInterfaces() {
        return this.getAllInterfaces(null);
    }

    @Override
    public IType[] getAllInterfaces(ITypeFilter filter) {
        return this.getAllInterfaces(filter, null);
    }

    @Override
    public IType[] getAllInterfaces(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllInterfaces();
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public boolean isSubtype(IType type, IType potentialSubtype) {
        if (CompareUtility.equals((Object)type, (Object)potentialSubtype)) {
            return true;
        }
        this.revalidate(null);
        HashSet allSubTypes = (HashSet)TypeHierarchy.getTypesFilteredAndSortedImpl(this.m_hierarchy.getAllSubtypes(type), null, null);
        return allSubTypes.contains(potentialSubtype);
    }

    @Override
    public IType[] getAllSubtypes(IType type) {
        return this.getAllSubtypes(type, null);
    }

    @Override
    public IType[] getAllSubtypes(IType type, ITypeFilter filter) {
        return this.getAllSubtypes(type, filter, null);
    }

    @Override
    public IType[] getAllSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] subtypes = this.m_hierarchy.getAllSubtypes(type);
        return TypeHierarchy.getTypesFilteredAndSorted(subtypes, filter, comparator);
    }

    @Override
    public IType[] getAllSuperclasses(IType type) {
        return this.getAllSuperclasses(type, null);
    }

    @Override
    public IType[] getAllSuperclasses(IType type, ITypeFilter filter) {
        return this.getAllSuperclasses(type, filter, null);
    }

    @Override
    public IType[] getAllSuperclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSuperclasses(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type) {
        return this.getAllSuperInterfaces(type, null);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getAllSuperInterfaces(type, filter, null);
    }

    @Override
    public IType[] getAllSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSuperInterfaces(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getAllSupertypes(IType type) {
        return this.getAllSupertypes(type, null);
    }

    @Override
    public IType[] getAllSupertypes(IType type, ITypeFilter filter) {
        return this.getAllSupertypes(type, filter, null);
    }

    @Override
    public IType[] getAllSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllSupertypes(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getAllTypes() {
        return this.getAllTypes(null);
    }

    @Override
    public IType[] getAllTypes(ITypeFilter filter) {
        return this.getAllTypes(filter, null);
    }

    @Override
    public IType[] getAllTypes(ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getAllTypes();
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getSubclasses(IType type) {
        return this.getSubclasses(type, null);
    }

    @Override
    public IType[] getSubclasses(IType type, ITypeFilter filter) {
        return this.getSubclasses(type, filter, null);
    }

    @Override
    public IType[] getSubclasses(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSubclasses(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getSubtypes(IType type) {
        return this.getSubtypes(type, null);
    }

    @Override
    public IType[] getSubtypes(IType type, ITypeFilter filter) {
        return this.getSubtypes(type, filter, null);
    }

    @Override
    public IType[] getSubtypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSubtypes(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType getSuperclass(IType type) {
        this.revalidate(null);
        IType superclass = this.m_hierarchy.getSuperclass(type);
        if (!TypeUtility.exists((IJavaElement)superclass)) {
            superclass = null;
        }
        return superclass;
    }

    @Override
    public IType[] getSuperInterfaces(IType type) {
        return this.getSuperInterfaces(type, null);
    }

    @Override
    public IType[] getSuperInterfaces(IType type, ITypeFilter filter) {
        return this.getSuperInterfaces(type, filter, null);
    }

    @Override
    public IType[] getSuperInterfaces(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSuperInterfaces(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    @Override
    public IType[] getSupertypes(IType type) {
        return this.getSupertypes(type, null);
    }

    @Override
    public IType[] getSupertypes(IType type, ITypeFilter filter) {
        return this.getSupertypes(type, filter, null);
    }

    @Override
    public IType[] getSupertypes(IType type, ITypeFilter filter, Comparator<IType> comparator) {
        this.revalidate(null);
        IType[] types = this.m_hierarchy.getSupertypes(type);
        return TypeHierarchy.getTypesFilteredAndSorted(types, filter, comparator);
    }

    private static IType[] getTypesFilteredAndSorted(IType[] types, ITypeFilter filter, Comparator<IType> comparator) {
        Collection<IType> result = TypeHierarchy.getTypesFilteredAndSortedImpl(types, filter, comparator);
        return result.toArray(new IType[result.size()]);
    }

    private static Collection<IType> getTypesFilteredAndSortedImpl(IType[] types, ITypeFilter filter, Comparator<IType> comparator) {
        AbstractSet result = null;
        result = comparator == null ? new HashSet() : new TreeSet<IType>(comparator);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType candidate = iTypeArray[n2];
            if (TypeUtility.exists((IJavaElement)candidate) && (filter == null || filter.accept(candidate))) {
                result.add((IType)candidate);
            }
            ++n2;
        }
        return result;
    }
}

