/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.util.signature;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.util.internal.SdkUtilActivator;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureUtility;

public class ImportValidator
implements IImportValidator {
    private final Map<String, String> m_initialImports;
    private final Map<String, String> m_newImports;
    private final String m_packageName;
    private static final Pattern EXT_REGEX = Pattern.compile("^\\+.*$");
    private static final Pattern EXT_REPL_REGEX = Pattern.compile("^\\+");
    private static final Pattern PLAIN_REPL_REGEX = Pattern.compile("^[\\[\\+]*");
    private static final String EXT_PREFIX = "? extends ";

    public ImportValidator(Map<String, String> initialImports, String packageName) {
        this.m_initialImports = initialImports == null ? Collections.emptyMap() : Collections.unmodifiableMap(initialImports);
        this.m_newImports = new HashMap<String, String>();
        this.m_packageName = packageName;
    }

    public ImportValidator() {
        this((String)null);
    }

    public ImportValidator(String packageName) {
        this(new HashMap<String, String>(0), packageName);
    }

    public ImportValidator(ICompilationUnit icu) {
        this(ImportValidator.getImportsFromIcu(icu), ImportValidator.getPackageFromIcu(icu));
    }

    protected static String getPackageFromIcu(ICompilationUnit icu) {
        String pck = null;
        try {
            IPackageDeclaration[] packageDeclarations = icu.getPackageDeclarations();
            if (packageDeclarations != null && packageDeclarations.length > 0) {
                pck = packageDeclarations[0].getElementName();
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not get package of compilation unit '" + icu.getElementName() + "'!", e);
        }
        return pck;
    }

    protected static Map<String, String> getImportsFromIcu(ICompilationUnit icu) {
        HashMap<String, String> usedImps = null;
        try {
            IImportDeclaration[] imports = icu.getImports();
            usedImps = new HashMap<String, String>(imports.length);
            IImportDeclaration[] iImportDeclarationArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IImportDeclaration imp = iImportDeclarationArray[n2];
                String fqImp = imp.getElementName();
                String packageName = Signature.getQualifier((String)fqImp);
                String simpleName = Signature.getSimpleName((String)fqImp);
                usedImps.put(simpleName, packageName);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            SdkUtilActivator.logWarning("could not collect imports of compilation unit '" + icu.getElementName() + "'!", e);
        }
        return usedImps;
    }

    @Override
    public String getTypeName(String singleTypeSignature) {
        int kind = SignatureUtility.getTypeSignatureKind(singleTypeSignature);
        if (kind == 2) {
            return Signature.getSignatureSimpleName((String)singleTypeSignature);
        }
        if (singleTypeSignature.charAt(0) == 'Q') {
            return Signature.getSignatureSimpleName((String)singleTypeSignature);
        }
        StringBuilder result = new StringBuilder(singleTypeSignature.length() + EXT_PREFIX.length());
        if (EXT_REGEX.matcher(singleTypeSignature).matches()) {
            result.append(EXT_PREFIX);
            singleTypeSignature = EXT_REPL_REGEX.matcher(singleTypeSignature).replaceAll("");
        }
        String pckName = Signature.getSignatureQualifier((String)singleTypeSignature);
        String simpleName = Signature.getSignatureSimpleName((String)singleTypeSignature);
        String plainSimpleName = Signature.getSignatureSimpleName((String)PLAIN_REPL_REGEX.matcher(singleTypeSignature).replaceAll(""));
        if (!StringUtility.hasText((String)pckName)) {
            return simpleName;
        }
        if (this.isAlreadyUsed(pckName, plainSimpleName)) {
            result.append(pckName).append(".");
        } else {
            this.m_newImports.put(plainSimpleName, pckName);
        }
        return result.append(simpleName).toString();
    }

    protected String findUsedPackageName(String simpleName) {
        if (this.m_initialImports.containsKey(simpleName)) {
            return this.m_initialImports.get(simpleName);
        }
        return this.m_newImports.get(simpleName);
    }

    protected boolean isAlreadyUsed(String packageName, String simpleName) {
        String usedPackageName = this.findUsedPackageName(simpleName);
        return usedPackageName != null && !usedPackageName.equals(packageName);
    }

    @Override
    public void addImport(String fqn) {
        String packageName = Signature.getQualifier((String)fqn);
        String simpleName = Signature.getSimpleName((String)fqn);
        this.m_newImports.put(simpleName, packageName);
    }

    @Override
    public Set<String> getImportsToCreate() {
        TreeSet<String> importsToCreate = new TreeSet<String>();
        for (Map.Entry<String, String> e : this.m_newImports.entrySet()) {
            String pck = e.getValue();
            String simpleName = e.getKey();
            if ("java.lang".equals(pck) || pck.equals(this.getPackageName())) continue;
            importsToCreate.add(String.valueOf(pck) + "." + simpleName);
        }
        return importsToCreate;
    }

    public String getPackageName() {
        return this.m_packageName;
    }
}

