/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.marker.commands;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.marker.commands.AbstractExecutableMarkerCommand;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MissingBuildJaxWsEntryCommand
extends AbstractExecutableMarkerCommand {
    private IScoutBundle m_bundle;
    private String m_alias;
    private WebserviceEnum m_webserviceEnum;

    public MissingBuildJaxWsEntryCommand(IScoutBundle bundle, String alias, WebserviceEnum webserviceEnum) {
        super("Missing entry in " + JaxWsConstants.PATH_BUILD_JAXWS);
        this.m_bundle = bundle;
        this.m_alias = alias;
        this.m_webserviceEnum = webserviceEnum;
        this.setSolutionDescription("By using this task, the missing entry is created for the webservice '" + alias + "'.");
    }

    @Override
    public void execute(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        Document xmlDocument = ResourceFactory.getBuildJaxWsResource(this.m_bundle).loadXml();
        Element xml = this.m_webserviceEnum == WebserviceEnum.Provider ? JaxWsSdkUtility.getChildElement(xmlDocument.getDocumentElement().getChildNodes(), "provider") : JaxWsSdkUtility.getChildElement(xmlDocument.getDocumentElement().getChildNodes(), "consumer");
        BuildJaxWsBean bean = new BuildJaxWsBean(xml, this.m_webserviceEnum);
        bean.setAlias(this.m_alias);
        ResourceFactory.getBuildJaxWsResource(this.m_bundle).storeXml(bean.getXml().getOwnerDocument(), 4, monitor, this.m_alias);
    }
}

