/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.util.JavaFileHandle;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;

public class ExternalFileCopyOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private boolean m_overwrite;
    private File m_externalFile;
    private IPath m_workspacePath;
    private IFile m_fileCopied;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("No bundle provided.");
        }
        if (this.m_externalFile == null) {
            throw new IllegalArgumentException("No file to copy provided.");
        }
        if (this.m_workspacePath == null) {
            throw new IllegalArgumentException("No workspace path provided.");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        block14: {
            IProject tempProject = null;
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                tempProject = workspace.getRoot().getProject("temp.project");
                if (!tempProject.exists()) {
                    tempProject.create((IProgressMonitor)new NullProgressMonitor());
                }
                if (!tempProject.isOpen()) {
                    tempProject.open((IProgressMonitor)new NullProgressMonitor());
                }
                IPath path = new JavaFileHandle(this.m_externalFile).getFullPath();
                IFile link = tempProject.getFile(path.lastSegment());
                link.createLink(path, 0, (IProgressMonitor)new NullProgressMonitor());
                if (link.exists() && link.isAccessible()) {
                    IProject project = this.m_bundle.getProject();
                    IPath projectPath = project.getFullPath();
                    IPath relativePath = this.m_workspacePath.append((IPath)new Path(link.getName()));
                    IFile targetFile = project.getFile(relativePath);
                    if (targetFile.exists()) {
                        if (this.m_overwrite) {
                            targetFile.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
                        } else {
                            throw new CoreException((IStatus)new ScoutStatus("File '" + targetFile.getFullPath().toString() + "' already exists."));
                        }
                    }
                    JaxWsSdkUtility.getFolder(this.m_bundle, this.m_workspacePath, true);
                    IPath destination = projectPath.append(relativePath);
                    link.copy(destination, true, (IProgressMonitor)new NullProgressMonitor());
                    this.m_fileCopied = this.m_bundle.getProject().getFile(destination.makeRelativeTo(projectPath));
                    break block14;
                }
                throw new CoreException((IStatus)new ScoutStatus("Temporary link '" + link.getFullPath().toString() + "' is not accessible."));
            }
            finally {
                if (tempProject != null && tempProject.exists()) {
                    try {
                        tempProject.delete(true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        JaxWsSdk.logError("Could not cleanup temporary project for copying file.", e);
                    }
                }
            }
        }
    }

    public String getOperationName() {
        return ExternalFileCopyOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public File getExternalFile() {
        return this.m_externalFile;
    }

    public void setExternalFile(File externalFile) {
        this.m_externalFile = externalFile;
    }

    public IPath getWorkspacePath() {
        return this.m_workspacePath;
    }

    public void setWorkspacePath(IPath workspacePath) {
        this.m_workspacePath = workspacePath;
    }

    public IFile getFileCopied() {
        return this.m_fileCopied;
    }

    public boolean isOverwrite() {
        return this.m_overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.m_overwrite = overwrite;
    }
}

