/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.operation.SunJaxWsFileCreateOperation;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.resource.XmlResource;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SunJaxWsEntryCreateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_alias;
    private String m_implTypeQualifiedName;
    private QName m_serviceQName;
    private QName m_portQName;
    private String m_urlPattern;
    private IPath m_wsdlProjectRelativePath;
    private SunJaxWsBean m_createdSunJaxWsBean;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (!StringUtility.hasText((String)this.m_alias)) {
            throw new IllegalArgumentException("alias must not be empty");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        XmlResource sunJaxWsResource = ResourceFactory.getSunJaxWsResource(this.m_bundle);
        if (sunJaxWsResource.getFile() == null || !sunJaxWsResource.getFile().exists()) {
            SunJaxWsFileCreateOperation op = new SunJaxWsFileCreateOperation(this.m_bundle);
            op.run(monitor, workingCopyManager);
        }
        Document xmlDocument = ResourceFactory.getSunJaxWsResource(this.m_bundle).loadXml();
        String namespacePrefix = JaxWsSdkUtility.getXmlPrefix(xmlDocument.getDocumentElement());
        Element endpointXml = xmlDocument.createElement(StringUtility.join((String)":", (Object[])new Object[]{namespacePrefix, "endpoint"}));
        xmlDocument.getDocumentElement().appendChild(endpointXml);
        SunJaxWsBean bean = new SunJaxWsBean(endpointXml);
        bean.setAlias(this.m_alias);
        bean.setImplementation(this.m_implTypeQualifiedName);
        if (this.m_serviceQName != null) {
            bean.setService(this.m_serviceQName.toString());
        }
        if (this.m_portQName != null) {
            bean.setPort(this.m_portQName.toString());
        }
        bean.setUrlPattern(this.m_urlPattern);
        bean.setWsdl(PathNormalizer.toWsdlPath(this.m_wsdlProjectRelativePath.toString()));
        this.m_createdSunJaxWsBean = bean;
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXml(this.m_createdSunJaxWsBean.getXml().getOwnerDocument(), 4, monitor, this.m_alias);
    }

    public String getOperationName() {
        return SunJaxWsEntryCreateOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public String getImplQName() {
        return this.m_implTypeQualifiedName;
    }

    public void setImplTypeQualifiedName(String implTypeQualifiedName) {
        this.m_implTypeQualifiedName = implTypeQualifiedName;
    }

    public QName getServiceQName() {
        return this.m_serviceQName;
    }

    public void setServiceQName(QName serviceQName) {
        this.m_serviceQName = serviceQName;
    }

    public QName getPortQName() {
        return this.m_portQName;
    }

    public void setPortQName(QName portQName) {
        this.m_portQName = portQName;
    }

    public String getUrlPattern() {
        return this.m_urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.m_urlPattern = urlPattern;
    }

    public IPath getWsdlProjectRelativePath() {
        return this.m_wsdlProjectRelativePath;
    }

    public void setWsdlProjectRelativePath(IPath wsdlProjectRelativePath) {
        this.m_wsdlProjectRelativePath = wsdlProjectRelativePath.makeRelative();
    }

    public SunJaxWsBean getCreatedSunJaxWsBean() {
        return this.m_createdSunJaxWsBean;
    }
}

