/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import javax.jws.WebService;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.operation.jdt.type.PrimaryTypeNewOperation;
import org.eclipse.scout.sdk.sourcebuilder.annotation.AnnotationSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.annotation.IAnnotationSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.comment.CommentSourceBuilderFactory;
import org.eclipse.scout.sdk.sourcebuilder.method.IMethodSourceBuilder;
import org.eclipse.scout.sdk.sourcebuilder.method.MethodSourceBuilderFactory;
import org.eclipse.scout.sdk.sourcebuilder.type.ITypeSourceBuilder;
import org.eclipse.scout.sdk.util.signature.IImportValidator;
import org.eclipse.scout.sdk.util.signature.SignatureCache;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;

public class WsProviderImplNewOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private String m_typeName;
    private String m_packageName;
    private IType m_portTypeInterfaceType;
    private boolean m_createScoutWebServiceAnnotation;
    private String m_sessionFactoryQName;
    private String m_authenticationHandlerQName;
    private String m_credentialValidationStrategyQName;
    private IType m_createdType;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_typeName == null) {
            throw new IllegalArgumentException("typeName not set");
        }
        if (this.m_packageName == null) {
            throw new IllegalArgumentException("packageName not set");
        }
    }

    public void run(final IProgressMonitor monitor, final IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        PrimaryTypeNewOperation implNewTypeOp = new PrimaryTypeNewOperation(this.m_typeName, this.m_packageName, this.m_bundle.getJavaProject());
        implNewTypeOp.setIcuCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesCompilationUnitCommentBuilder());
        implNewTypeOp.setTypeCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesTypeCommentBuilder());
        implNewTypeOp.setFlags(1);
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            implNewTypeOp.addInterfaceSignature(SignatureCache.createTypeSignature((String)this.m_portTypeInterfaceType.getFullyQualifiedName()));
        } else {
            JaxWsSdk.logError("Could not link webservice provider to port type as port type could not be found");
        }
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            IMethod[] iMethodArray = this.m_portTypeInterfaceType.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod method = iMethodArray[n2];
                IMethodSourceBuilder methodSourceBuilder = MethodSourceBuilderFactory.createOverrideMethodSourceBuilder((ITypeSourceBuilder)implNewTypeOp.getSourceBuilder(), (String)method.getElementName());
                implNewTypeOp.addMethodSourceBuilder(methodSourceBuilder);
                ++n2;
            }
        }
        AnnotationSourceBuilder webServiceAnnot = new AnnotationSourceBuilder(SignatureCache.createTypeSignature((String)WebService.class.getName()));
        if (TypeUtility.exists((IJavaElement)this.m_portTypeInterfaceType)) {
            webServiceAnnot.addParameter("endpointInterface=\"" + this.m_portTypeInterfaceType.getFullyQualifiedName() + "\"");
        }
        implNewTypeOp.addAnnotationSourceBuilder((IAnnotationSourceBuilder)webServiceAnnot);
        if (this.m_createScoutWebServiceAnnotation) {
            final String defaultSessionFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("sessionFactory", new String[0]).getDefaultValue().getValue();
            final String defaultAuthFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("authenticationHandler", new String[0]).getDefaultValue().getValue();
            final String defaultCredentialFactory = (String)TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService").getMethod("credentialValidationStrategy", new String[0]).getDefaultValue().getValue();
            AnnotationSourceBuilder scoutWebServiceAnnot = new AnnotationSourceBuilder(SignatureCache.createTypeSignature((String)"org.eclipse.scout.jaxws.annotation.ScoutWebService")){

                public void createSource(StringBuilder source, String lineDelimiter, IJavaProject ownerProject, IImportValidator validator) throws CoreException {
                    IType type;
                    if (WsProviderImplNewOperation.this.m_sessionFactoryQName != null && !WsProviderImplNewOperation.this.isSameType(WsProviderImplNewOperation.this.m_sessionFactoryQName, defaultSessionFactory)) {
                        type = WsProviderImplNewOperation.this.createType(WsProviderImplNewOperation.this.m_sessionFactoryQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.session.IServerSessionFactory"), monitor, workingCopyManager);
                        this.addParameter("sessionFactory=" + validator.getTypeName(SignatureCache.createTypeSignature((String)type.getFullyQualifiedName())) + ".class");
                    }
                    if (WsProviderImplNewOperation.this.m_authenticationHandlerQName != null && !WsProviderImplNewOperation.this.isSameType(WsProviderImplNewOperation.this.m_authenticationHandlerQName, defaultAuthFactory)) {
                        type = WsProviderImplNewOperation.this.createType(WsProviderImplNewOperation.this.m_authenticationHandlerQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.IAuthenticationHandler"), monitor, workingCopyManager);
                        this.addParameter("authenticationHandler=" + validator.getTypeName(SignatureCache.createTypeSignature((String)type.getFullyQualifiedName())) + ".class");
                    }
                    if (WsProviderImplNewOperation.this.m_credentialValidationStrategyQName != null && !WsProviderImplNewOperation.this.isSameType(WsProviderImplNewOperation.this.m_credentialValidationStrategyQName, defaultCredentialFactory)) {
                        type = WsProviderImplNewOperation.this.createType(WsProviderImplNewOperation.this.m_credentialValidationStrategyQName, TypeUtility.getType((String)"org.eclipse.scout.jaxws.security.provider.ICredentialValidationStrategy"), monitor, workingCopyManager);
                        this.addParameter("credentialValidationStrategy=" + validator.getTypeName(SignatureCache.createTypeSignature((String)type.getFullyQualifiedName())) + ".class");
                    }
                    super.createSource(source, lineDelimiter, ownerProject, validator);
                }
            };
            implNewTypeOp.addAnnotationSourceBuilder((IAnnotationSourceBuilder)scoutWebServiceAnnot);
        }
        implNewTypeOp.setFormatSource(true);
        implNewTypeOp.validate();
        implNewTypeOp.run(monitor, workingCopyManager);
        this.m_createdType = implNewTypeOp.getCreatedType();
    }

    private IType createType(String qualifiedTypeName, IType interfaceType, IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException {
        IType type;
        if (TypeUtility.existsType((String)qualifiedTypeName)) {
            type = TypeUtility.getType((String)qualifiedTypeName);
        } else {
            String typeName = Signature.getSimpleName((String)qualifiedTypeName);
            String packageName = Signature.getQualifier((String)qualifiedTypeName);
            PrimaryTypeNewOperation newTypeOp = new PrimaryTypeNewOperation(typeName, packageName, this.m_bundle.getJavaProject());
            newTypeOp.setIcuCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesCompilationUnitCommentBuilder());
            newTypeOp.setTypeCommentSourceBuilder(CommentSourceBuilderFactory.createPreferencesTypeCommentBuilder());
            newTypeOp.setFlags(1);
            newTypeOp.addInterfaceSignature(SignatureCache.createTypeSignature((String)interfaceType.getFullyQualifiedName()));
            newTypeOp.run(monitor, workingCopyManager);
            type = newTypeOp.getCreatedType();
            workingCopyManager.register(type.getCompilationUnit(), monitor);
        }
        return type;
    }

    public String getOperationName() {
        return WsProviderImplNewOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String typeName) {
        this.m_typeName = typeName;
    }

    public String getPackageName() {
        return this.m_packageName;
    }

    public void setPackageName(String packageName) {
        this.m_packageName = packageName;
    }

    public boolean isCreateScoutWebserviceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreateScoutWebServiceAnnotation(boolean createScoutWebServiceAnnotation) {
        this.m_createScoutWebServiceAnnotation = createScoutWebServiceAnnotation;
    }

    public String getSessionFactoryQName() {
        return this.m_sessionFactoryQName;
    }

    public void setSessionFactoryQName(String sessionFactoryQName) {
        this.m_sessionFactoryQName = sessionFactoryQName;
    }

    public String getAuthenticationHandlerQName() {
        return this.m_authenticationHandlerQName;
    }

    public void setAuthenticationHandlerQName(String authenticationHandlerQName) {
        this.m_authenticationHandlerQName = authenticationHandlerQName;
    }

    public String getCredentialValidationStrategyQName() {
        return this.m_credentialValidationStrategyQName;
    }

    public void setCredentialValidationStrategyQName(String credentialValidationStrategyQName) {
        this.m_credentialValidationStrategyQName = credentialValidationStrategyQName;
    }

    public boolean isCreateScoutWebServiceAnnotation() {
        return this.m_createScoutWebServiceAnnotation;
    }

    public void setCreatedType(IType createdType) {
        this.m_createdType = createdType;
    }

    public IType getCreatedType() {
        return this.m_createdType;
    }

    public IType getPortTypeInterfaceType() {
        return this.m_portTypeInterfaceType;
    }

    public void setPortTypeInterfaceType(IType portTypeInterfaceType) {
        this.m_portTypeInterfaceType = portTypeInterfaceType;
    }

    private boolean isSameType(String fullyQualifiedName1, String fullyQualifiedName2) {
        if (fullyQualifiedName1 != null) {
            fullyQualifiedName1 = fullyQualifiedName1.replaceAll("\\$", ".");
        }
        if (fullyQualifiedName2 != null) {
            fullyQualifiedName2 = fullyQualifiedName2.replaceAll("\\$", ".");
        }
        return CompareUtility.equals((Object)fullyQualifiedName1, (Object)fullyQualifiedName2);
    }
}

