/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.operation;

import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.extensions.soap.SOAPBinding;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.util.log.ScoutStatus;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.operation.WsdlStyleEnum;
import org.eclipse.scout.sdk.ws.jaxws.resource.WsdlResource;
import org.eclipse.scout.sdk.ws.jaxws.util.PathNormalizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WsdlCreateOperation
implements IOperation {
    private IScoutBundle m_bundle;
    private WsdlResource m_wsdlResource;
    private String m_alias;
    private String m_targetNamespace;
    private String m_service;
    private String m_portName;
    private String m_portType;
    private String m_binding;
    private String m_urlPattern;
    private String m_serviceOperationName;
    private WsdlStyleEnum m_wsdlStyle;

    public void validate() throws IllegalArgumentException {
        if (this.m_bundle == null) {
            throw new IllegalArgumentException("bundle not set");
        }
        if (this.m_wsdlResource == null) {
            throw new IllegalArgumentException("WSDL resource must not be null");
        }
        if (!StringUtility.hasText((String)this.m_alias)) {
            throw new IllegalArgumentException("alias must not be empty");
        }
        if (this.m_targetNamespace == null) {
            throw new IllegalArgumentException("no targetNamespace set");
        }
        if (this.m_service == null) {
            throw new IllegalArgumentException("no service set");
        }
        if (this.m_portName == null) {
            throw new IllegalArgumentException("no port set");
        }
        if (this.m_portType == null) {
            throw new IllegalArgumentException("no porttype set");
        }
        if (this.m_binding == null) {
            throw new IllegalArgumentException("no binding set");
        }
        if (this.m_urlPattern == null) {
            throw new IllegalArgumentException("no urlPattern set");
        }
        if (this.m_serviceOperationName == null) {
            throw new IllegalArgumentException("no serviceOperationName set");
        }
    }

    public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        try {
            Element schemaElementXml;
            WSDLFactory factory = WSDLFactory.newInstance();
            WSDLWriter writer = factory.newWSDLWriter();
            Definition definition = factory.newDefinition();
            definition.setExtensionRegistry(factory.newPopulatedExtensionRegistry());
            String targetNamespace = PathNormalizer.toTargetNamespace(this.m_targetNamespace);
            definition.setQName(new QName(this.m_alias));
            definition.setTargetNamespace(targetNamespace);
            definition.addNamespace("tns", targetNamespace);
            definition.addNamespace("mime", "http://schemas.xmlsoap.org/wsdl/mime/");
            definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            definition.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
            definition.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
            definition.addNamespace("http", "http://schemas.xmlsoap.org/wsdl/http/");
            Document document = writer.getDocument(definition);
            PortType portType = definition.createPortType();
            definition.addPortType(portType);
            portType.setUndefined(false);
            portType.setQName(new QName(definition.getNamespace("tns"), this.m_portType));
            Binding binding = definition.createBinding();
            definition.addBinding(binding);
            binding.setUndefined(false);
            binding.setQName(new QName(definition.getNamespace("tns"), this.m_binding));
            binding.setPortType(portType);
            SOAPBinding soapBinding = (SOAPBinding)definition.getExtensionRegistry().createExtension(Binding.class, new QName(definition.getNamespace("soap"), "binding"));
            binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
            soapBinding.setStyle("document");
            soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
            soapBinding.setElementType(new QName(definition.getNamespace("soap"), "binding"));
            BindingOperation bindingOperation = definition.createBindingOperation();
            binding.addBindingOperation(bindingOperation);
            bindingOperation.setName(this.m_serviceOperationName);
            SOAPOperation soapOperation = (SOAPOperation)definition.getExtensionRegistry().createExtension(BindingOperation.class, new QName(definition.getNamespace("soap"), "operation"));
            bindingOperation.addExtensibilityElement((ExtensibilityElement)soapOperation);
            soapOperation.setSoapActionURI(PathNormalizer.removeTrailingSeparatorFromTargetNamespace(String.valueOf(targetNamespace) + this.m_serviceOperationName));
            BindingInput bindingInput = definition.createBindingInput();
            bindingOperation.setBindingInput(bindingInput);
            SOAPBody soapBody = (SOAPBody)definition.getExtensionRegistry().createExtension(BindingInput.class, new QName(definition.getNamespace("soap"), "body"));
            soapBody.setUse("literal");
            bindingInput.addExtensibilityElement((ExtensibilityElement)soapBody);
            BindingOutput bindingOutput = definition.createBindingOutput();
            bindingOperation.setBindingOutput(bindingOutput);
            soapBody = (SOAPBody)definition.getExtensionRegistry().createExtension(BindingOutput.class, new QName(definition.getNamespace("soap"), "body"));
            soapBody.setUse("literal");
            bindingOutput.addExtensibilityElement((ExtensibilityElement)soapBody);
            Service service = definition.createService();
            definition.addService(service);
            service.setQName(new QName(this.m_service));
            Port port = definition.createPort();
            service.addPort(port);
            port.setName(this.m_portName);
            port.setBinding(binding);
            SOAPAddressImpl httpAddress = new SOAPAddressImpl();
            httpAddress.setLocationURI(PathNormalizer.removeTrailingSeparatorFromTargetNamespace(targetNamespace));
            httpAddress.setElementType(new QName(definition.getNamespace("soap"), "address"));
            port.addExtensibilityElement((ExtensibilityElement)httpAddress);
            Message messageRequest = definition.createMessage();
            messageRequest.setUndefined(false);
            messageRequest.setQName(new QName(definition.getNamespace("tns"), String.valueOf(this.m_serviceOperationName) + "Request"));
            Part messagePartRequest = definition.createPart();
            if (this.getWsdlStyle() == WsdlStyleEnum.DocumentLiteralWrapped) {
                messagePartRequest.setName("parameters");
                messagePartRequest.setElementName(new QName(definition.getNamespace("tns"), this.m_serviceOperationName));
            } else {
                messagePartRequest.setName("in");
                messagePartRequest.setElementName(new QName(definition.getNamespace("tns"), "inElement"));
            }
            messageRequest.addPart(messagePartRequest);
            definition.addMessage(messageRequest);
            Message messageResponse = definition.createMessage();
            messageResponse.setUndefined(false);
            messageResponse.setQName(new QName(definition.getNamespace("tns"), String.valueOf(this.m_serviceOperationName) + "Response"));
            Part messagePartResponse = definition.createPart();
            if (this.getWsdlStyle() == WsdlStyleEnum.DocumentLiteralWrapped) {
                messagePartResponse.setName("parameters");
                messagePartResponse.setElementName(new QName(definition.getNamespace("tns"), String.valueOf(this.m_serviceOperationName) + "Response"));
            } else {
                messagePartResponse.setName("out");
                messagePartResponse.setElementName(new QName(definition.getNamespace("tns"), "outElement"));
            }
            messageResponse.addPart(messagePartResponse);
            definition.addMessage(messageResponse);
            Operation operation = definition.createOperation();
            operation.setUndefined(false);
            operation.setName(this.m_serviceOperationName);
            Input input = definition.createInput();
            operation.setInput(input);
            input.setMessage(messageRequest);
            Output output = definition.createOutput();
            operation.setOutput(output);
            portType.addOperation(operation);
            output.setMessage(messageResponse);
            Types types = definition.createTypes();
            Schema schema = (Schema)definition.getExtensionRegistry().createExtension(Types.class, new QName(definition.getNamespace("xsd"), "schema"));
            types.addExtensibilityElement((ExtensibilityElement)schema);
            Element schemaXml = document.createElement("xsd:schema");
            schema.setElement(schemaXml);
            schemaXml.setAttribute("xmlns:xsd", definition.getNamespace("xsd"));
            schemaXml.setAttribute("targetNamespace", targetNamespace);
            if (this.getWsdlStyle() == WsdlStyleEnum.DocumentLiteralWrapped) {
                schemaElementXml = this.createDocumentLiteralWrappedSchemaElement(document, messagePartRequest, "in", "xsd:string");
                schemaXml.appendChild(schemaElementXml);
            } else {
                schemaElementXml = this.createDocumentLiteralSchemaElement(document, messagePartRequest, "xsd:string");
            }
            schemaXml.appendChild(schemaElementXml);
            if (this.getWsdlStyle() == WsdlStyleEnum.DocumentLiteralWrapped) {
                schemaElementXml = this.createDocumentLiteralWrappedSchemaElement(document, messagePartResponse, "out", "xsd:string");
                schemaXml.appendChild(schemaElementXml);
            } else {
                schemaElementXml = this.createDocumentLiteralSchemaElement(document, messagePartResponse, "xsd:string");
            }
            schemaXml.appendChild(schemaElementXml);
            definition.setTypes(types);
            this.m_wsdlResource.storeWsdl(definition, "", 2, monitor);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ScoutStatus(4, "Could not persist WSDL file.", (Throwable)e));
        }
    }

    private Element createDocumentLiteralWrappedSchemaElement(Document document, Part part, String parameterName, String parameterXsdType) {
        Element xmlElement = document.createElement("xsd:element");
        xmlElement.setAttribute("name", part.getElementName().getLocalPart());
        Element xmlComplexType = document.createElement("xsd:complexType");
        xmlElement.appendChild(xmlComplexType);
        Element xmlSequence = document.createElement("xsd:sequence");
        xmlComplexType.appendChild(xmlSequence);
        Element xmlParameter = document.createElement("xsd:element");
        xmlParameter.setAttribute("name", parameterName);
        xmlParameter.setAttribute("type", parameterXsdType);
        xmlSequence.appendChild(xmlParameter);
        return xmlElement;
    }

    private Element createDocumentLiteralSchemaElement(Document document, Part part, String parameterXsdType) {
        Element xmlElement = document.createElement("xsd:element");
        xmlElement.setAttribute("name", part.getElementName().getLocalPart());
        xmlElement.setAttribute("type", parameterXsdType);
        return xmlElement;
    }

    public String getOperationName() {
        return WsdlCreateOperation.class.getName();
    }

    public IScoutBundle getBundle() {
        return this.m_bundle;
    }

    public void setBundle(IScoutBundle bundle) {
        this.m_bundle = bundle;
    }

    public String getAlias() {
        return this.m_alias;
    }

    public void setAlias(String alias) {
        this.m_alias = alias;
    }

    public WsdlResource getWsdlResource() {
        return this.m_wsdlResource;
    }

    public void setWsdlResource(WsdlResource wsdlResource) {
        this.m_wsdlResource = wsdlResource;
    }

    public String getTargetNamespace() {
        return this.m_targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.m_targetNamespace = targetNamespace;
    }

    public String getService() {
        return this.m_service;
    }

    public void setService(String service) {
        this.m_service = service;
    }

    public String getPort() {
        return this.m_portName;
    }

    public void setPortName(String portName) {
        this.m_portName = portName;
    }

    public String getPortType() {
        return this.m_portType;
    }

    public void setPortType(String portType) {
        this.m_portType = portType;
    }

    public String getBinding() {
        return this.m_binding;
    }

    public void setBinding(String binding) {
        this.m_binding = binding;
    }

    public String getUrlPattern() {
        return this.m_urlPattern;
    }

    public void setUrlPattern(String urlPattern) {
        this.m_urlPattern = urlPattern;
    }

    public String getServiceOperationName() {
        return this.m_serviceOperationName;
    }

    public void setServiceOperationName(String serviceOperationName) {
        this.m_serviceOperationName = serviceOperationName;
    }

    public WsdlStyleEnum getWsdlStyle() {
        return this.m_wsdlStyle;
    }

    public void setWsdlStyle(WsdlStyleEnum wsdlStyleEnum) {
        this.m_wsdlStyle = wsdlStyleEnum;
    }
}

