/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.action;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.outline.pages.IPage;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.resource.ResourceFactory;
import org.eclipse.scout.sdk.ws.jaxws.swt.action.AbstractLinkAction;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Element;

public class HandlerChainNewAction
extends AbstractLinkAction {
    private SunJaxWsBean m_sunJaxWsBean;
    private IScoutBundle m_bundle;

    public HandlerChainNewAction() {
        super(Texts.get("HandlerChainNewAction"), ScoutSdkUi.getImageDescriptor((String)"add.png"));
        this.setLinkText(Texts.get("HandlerChainNewAction"));
        this.setToolTip(Texts.get("TooltipHanderChainNew"));
    }

    public void init(IScoutBundle bundle, SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.m_bundle = bundle;
    }

    public boolean isVisible() {
        return !this.m_bundle.isBinary();
    }

    public Object execute(Shell shell, IPage[] selection, ExecutionEvent event) throws ExecutionException {
        String handlerChainsQName = this.toQualifiedName("handler-chains");
        Element xmlHandlerChains = JaxWsSdkUtility.getChildElement(this.m_sunJaxWsBean.getXml().getChildNodes(), handlerChainsQName);
        if (xmlHandlerChains == null) {
            xmlHandlerChains = this.m_sunJaxWsBean.getXml().getOwnerDocument().createElementNS("http://java.sun.com/xml/ns/javaee", handlerChainsQName);
            this.m_sunJaxWsBean.getXml().appendChild(xmlHandlerChains);
        }
        Element xmlHandlerChain = xmlHandlerChains.getOwnerDocument().createElement(this.toQualifiedName("handler-chain"));
        xmlHandlerChains.appendChild(xmlHandlerChain);
        ResourceFactory.getSunJaxWsResource(this.m_bundle).storeXmlAsync(xmlHandlerChain.getOwnerDocument(), 512, this.m_sunJaxWsBean.getAlias());
        return null;
    }

    private String toQualifiedName(String elementName) {
        return this.m_sunJaxWsBean.toQualifiedName(elementName);
    }
}

