/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.scout.sdk.jobs.OperationJob;
import org.eclipse.scout.sdk.operation.IOperation;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.util.type.TypeUtility;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsSdk;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.AnnotationUpdateOperation;
import org.eclipse.scout.sdk.ws.jaxws.operation.SourceRangeRemoveOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.AbstractPropertyPresenter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class AnnotationPresenter
extends AbstractPropertyPresenter<IAnnotation> {
    private IType m_type;
    private IType m_annotationType;
    protected Button m_checkbox;
    protected Label m_label;
    private SelectionListener m_selectionListener = new P_SelectionListener();

    public AnnotationPresenter(Composite parent, PropertyViewFormToolkit toolkit, IType type, IType annotationType) {
        super(parent, toolkit, false);
        this.m_type = type;
        this.m_annotationType = annotationType;
        this.setLinkAlwaysEnabled(true);
        this.callInitializer();
    }

    @Override
    protected Control createContent(Composite parent) {
        this.m_checkbox = new Button(parent, 32);
        this.m_label = new Label(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.m_checkbox.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        this.m_label.setLayoutData((Object)gd);
        this.m_label.setFont(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getFontRegistry().getItalic("org.eclipse.jface.dialogfont"));
        this.m_label.setText(Texts.get("inherited"));
        return this.m_checkbox;
    }

    @Override
    protected void setInputInternal(IAnnotation input) {
        this.m_checkbox.removeSelectionListener(this.m_selectionListener);
        try {
            this.m_checkbox.setSelection(input != null);
        }
        finally {
            this.m_checkbox.addSelectionListener(this.m_selectionListener);
        }
        this.updateStyle(input);
    }

    private void updateStyle(IAnnotation annotation) {
        this.m_label.setVisible(false);
        if (annotation != null) {
            this.setUseLinkAsLabel(true);
            if (JaxWsSdkUtility.isAnnotationOnDeclaringType(this.m_type, annotation)) {
                this.setBoldLabelText(true);
                this.setEnabled(true);
            } else {
                this.setTooltip(Texts.get("XisInheritedFromY", annotation.getElementName(), annotation.getParent().getElementName()));
                this.m_label.setVisible(true);
                this.setBoldLabelText(false);
                this.setEnabled(false);
            }
        } else {
            this.setUseLinkAsLabel(false);
            this.setBoldLabelText(false);
            this.setEnabled(true);
        }
    }

    @Override
    public void setInput(IAnnotation value) {
        throw new UnsupportedOperationException();
    }

    public void updatePresenter() {
        IAnnotation annotation = JaxWsSdkUtility.getAnnotation(this.m_type, this.m_annotationType.getFullyQualifiedName(), true);
        super.setInput(annotation);
    }

    @Override
    protected void setValueFromUI(IAnnotation newValue) {
        this.updateStyle(newValue);
        super.setValueFromUI(newValue);
    }

    @Override
    protected void execLinkAction() throws CoreException {
        if (this.getValue() == null) {
            return;
        }
        try {
            JavaUI.openInEditor((IJavaElement)((IJavaElement)this.getValue()));
        }
        catch (Exception e) {
            JaxWsSdk.logWarning(e);
        }
    }

    public IType getType() {
        return this.m_type;
    }

    public void setType(IType type) {
        this.m_type = type;
    }

    private class P_AnnotationCreateOperation
    implements IOperation {
        private P_AnnotationCreateOperation() {
        }

        public void validate() throws IllegalArgumentException {
        }

        public void run(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
            AnnotationUpdateOperation op = new AnnotationUpdateOperation();
            op.setAnnotationType(AnnotationPresenter.this.m_annotationType);
            op.setDeclaringType(AnnotationPresenter.this.m_type);
            op.run(monitor, workingCopyManager);
            final IAnnotation annotation = JaxWsSdkUtility.getAnnotation(AnnotationPresenter.this.m_type, AnnotationPresenter.this.m_annotationType.getFullyQualifiedName(), false);
            ScoutSdkUi.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    AnnotationPresenter.this.setValueFromUI(annotation);
                }
            });
        }

        public String getOperationName() {
            return P_AnnotationCreateOperation.class.getName();
        }
    }

    private final class P_SelectionListener
    extends SelectionAdapter {
        private P_SelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            if (AnnotationPresenter.this.m_checkbox.getSelection()) {
                P_AnnotationCreateOperation op = new P_AnnotationCreateOperation();
                new OperationJob(new IOperation[]{op}).schedule();
            } else {
                IAnnotation annotation = JaxWsSdkUtility.getAnnotation(AnnotationPresenter.this.m_type, TypeUtility.getType((String)"org.eclipse.scout.jaxws.annotation.ScoutTransaction").getFullyQualifiedName(), false);
                if (annotation != null) {
                    SourceRangeRemoveOperation op = new SourceRangeRemoveOperation();
                    op.setAnnotation(annotation);
                    op.setDeclaringType(AnnotationPresenter.this.m_type);
                    new OperationJob(new IOperation[]{op}).schedule();
                    AnnotationPresenter.this.setValueFromUI(null);
                }
            }
        }
    }
}

