/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter;

import org.eclipse.core.resources.IFolder;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.scout.sdk.ui.view.properties.PropertyViewFormToolkit;
import org.eclipse.scout.sdk.ws.jaxws.JaxWsConstants;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.swt.dialog.ScoutWizardDialogEx;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.BuildJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.model.SunJaxWsBean;
import org.eclipse.scout.sdk.ws.jaxws.swt.view.presenter.FolderPresenter;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.WsFileMoveWizard;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WebserviceEnum;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.WsdlFolderViewerFilter;
import org.eclipse.scout.sdk.ws.jaxws.util.JaxWsSdkUtility;
import org.eclipse.swt.widgets.Composite;

public class WsdlFolderPresenter
extends FolderPresenter {
    private WebserviceEnum m_webserviceEnum;
    private SunJaxWsBean m_sunJaxWsBean;
    private BuildJaxWsBean m_buildJaxWsBean;

    public WsdlFolderPresenter(Composite parent, PropertyViewFormToolkit toolkit, WebserviceEnum webserviceEnum) {
        super(parent, toolkit, 120, false);
        this.m_webserviceEnum = webserviceEnum;
        this.callInitializer();
    }

    @Override
    protected String getConfiguredBrowseButtonLabel() {
        return Texts.get("Change");
    }

    @Override
    protected IFolder execBrowseAction() {
        IFolder rootFolder = null;
        rootFolder = this.m_webserviceEnum == WebserviceEnum.Provider ? JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_PROVIDER, true) : JaxWsSdkUtility.getFolder(this.m_bundle, JaxWsConstants.PATH_WSDL_CONSUMER, true);
        IFolder folder = JaxWsSdkUtility.openProjectFolderDialog(this.m_bundle, new WsdlFolderViewerFilter(rootFolder), Texts.get("MovingFiles"), Texts.get("MoveWsdlFileAndArtefacts"), rootFolder, (IFolder)this.getValue());
        if (!(folder == null || this.getValue() != null && folder.getProjectRelativePath().equals((Object)((IFolder)this.getValue()).getProjectRelativePath()))) {
            WsFileMoveWizard wizard = new WsFileMoveWizard();
            wizard.setBundle(this.m_bundle);
            wizard.setWebserviceEnum(this.m_webserviceEnum);
            wizard.setBuildJaxWsBean(this.m_buildJaxWsBean);
            wizard.setSunJaxWsBean(this.m_sunJaxWsBean);
            wizard.setDestination(folder);
            wizard.setMarkerGroupUUID(this.getMarkerGroupUUID());
            ScoutWizardDialogEx wizardDialog = new ScoutWizardDialogEx((IWizard)wizard);
            if (wizardDialog.open() == 32) {
                return folder;
            }
        }
        return null;
    }

    public SunJaxWsBean getSunJaxWsBean() {
        return this.m_sunJaxWsBean;
    }

    public void setSunJaxWsBean(SunJaxWsBean sunJaxWsBean) {
        this.m_sunJaxWsBean = sunJaxWsBean;
        this.calculateAccessiblity();
    }

    public BuildJaxWsBean getBuildJaxWsBean() {
        return this.m_buildJaxWsBean;
    }

    public void setBuildJaxWsBean(BuildJaxWsBean buildJaxWsBean) {
        this.m_buildJaxWsBean = buildJaxWsBean;
        this.calculateAccessiblity();
    }

    private void calculateAccessiblity() {
        if (this.m_buildJaxWsBean == null) {
            this.setEnabled(false);
            return;
        }
        if (this.m_webserviceEnum == WebserviceEnum.Provider && this.m_sunJaxWsBean == null) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }
}

