/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizard;
import org.eclipse.scout.sdk.util.typecache.IWorkingCopyManager;
import org.eclipse.scout.sdk.workspace.IScoutBundle;
import org.eclipse.scout.sdk.ws.jaxws.Texts;
import org.eclipse.scout.sdk.ws.jaxws.operation.TypeNewOperation;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.TypeNewWizardPage;

public class TypeNewWizard
extends AbstractWorkspaceWizard {
    private IScoutBundle m_bundle;
    private String m_elementName;
    private String m_typeSuffix;
    private String m_recommendedPackageFragment;
    private boolean m_allowModifyPackage;
    private boolean m_allowModifySuperType;
    private boolean m_allowModifyInterfaceType;
    private TypeNewWizardPage.JavaSearchScopeFactory m_superTypeSearchScopeFactory;
    private TypeNewWizardPage.JavaSearchScopeFactory m_interfaceTypeSearchScopeFactory;
    private IType m_superType;
    private IType m_interfaceType;
    private TypeNewWizardPage m_page;
    private TypeNewOperation m_op;

    public TypeNewWizard(IScoutBundle bundle, String elementName) {
        this.m_bundle = bundle;
        this.m_elementName = elementName;
        this.setWindowTitle(Texts.get("CreateNewX", this.m_elementName));
    }

    public void addPages() {
        this.m_page = new TypeNewWizardPage(this.m_bundle, this.m_elementName);
        this.m_page.setAllowModifyInterfaceType(this.isAllowModifyInterfaceType());
        this.m_page.setAllowModifySuperType(this.isAllowModifySuperType());
        this.m_page.setAllowModifyPackage(this.isAllowModifyPackage());
        this.m_page.setRecommendedPackageFragment(this.getRecommendedPackageFragment());
        this.m_page.setTypeSuffix(this.getTypeSuffix());
        if (this.getSuperTypeSearchScopeFactory() != null) {
            this.m_page.setSuperTypeSearchScopeFactory(this.getSuperTypeSearchScopeFactory());
        } else {
            this.m_page.setSuperTypeSearchScopeFactory(new TypeNewWizardPage.JavaSearchScopeFactory());
        }
        if (this.getInterfaceTypeSearchScopeFactory() != null) {
            this.m_page.setInterfaceTypeSearchScopeFactory(this.getInterfaceTypeSearchScopeFactory());
        } else {
            this.m_page.setInterfaceTypeSearchScopeFactory(new TypeNewWizardPage.JavaSearchScopeFactory());
        }
        this.m_page.setSuperType(this.getSuperType());
        this.m_page.setInterfaceType(this.getInterfaceType());
        this.addPage((IWizardPage)this.m_page);
    }

    protected boolean beforeFinish() throws CoreException {
        this.m_op = new TypeNewOperation();
        this.m_op.setBundle(this.m_bundle);
        this.m_op.setPackageName(this.m_page.getPackageName());
        this.m_op.setTypeName(this.m_page.getTypeName());
        this.m_op.setInterfaceType(this.m_page.getInterfaceType());
        this.m_op.setSuperType(this.m_page.getSuperType());
        return true;
    }

    protected boolean performFinish(IProgressMonitor monitor, IWorkingCopyManager workingCopyManager) throws CoreException, IllegalArgumentException {
        this.m_op.run(monitor, workingCopyManager);
        return true;
    }

    public String getTypeSuffix() {
        return this.m_typeSuffix;
    }

    public void setTypeSuffix(String typeSuffix) {
        this.m_typeSuffix = typeSuffix;
    }

    public String getRecommendedPackageFragment() {
        return this.m_recommendedPackageFragment;
    }

    public void setRecommendedPackageFragment(String recommendedPackageFragment) {
        this.m_recommendedPackageFragment = recommendedPackageFragment;
    }

    public boolean isAllowModifyPackage() {
        return this.m_allowModifyPackage;
    }

    public void setAllowModifyPackage(boolean allowModifyPackage) {
        this.m_allowModifyPackage = allowModifyPackage;
    }

    public boolean isAllowModifySuperType() {
        return this.m_allowModifySuperType;
    }

    public void setAllowModifySuperType(boolean allowModifySuperType) {
        this.m_allowModifySuperType = allowModifySuperType;
    }

    public boolean isAllowModifyInterfaceType() {
        return this.m_allowModifyInterfaceType;
    }

    public void setAllowModifyInterfaceType(boolean allowModifyInterfaceType) {
        this.m_allowModifyInterfaceType = allowModifyInterfaceType;
    }

    public TypeNewWizardPage.JavaSearchScopeFactory getSuperTypeSearchScopeFactory() {
        return this.m_superTypeSearchScopeFactory;
    }

    public void setSuperTypeSearchScopeFactory(TypeNewWizardPage.JavaSearchScopeFactory superTypeSearchScopeFactory) {
        this.m_superTypeSearchScopeFactory = superTypeSearchScopeFactory;
    }

    public TypeNewWizardPage.JavaSearchScopeFactory getInterfaceTypeSearchScopeFactory() {
        return this.m_interfaceTypeSearchScopeFactory;
    }

    public void setInterfaceTypeSearchScopeFactory(TypeNewWizardPage.JavaSearchScopeFactory interfaceTypeSearchScopeFactory) {
        this.m_interfaceTypeSearchScopeFactory = interfaceTypeSearchScopeFactory;
    }

    public IType getSuperType() {
        return this.m_superType;
    }

    public void setSuperType(IType superType) {
        this.m_superType = superType;
    }

    public IType getInterfaceType() {
        return this.m_interfaceType;
    }

    public void setInterfaceType(IType interfaceType) {
        this.m_interfaceType = interfaceType;
    }
}

