/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.scout.sdk.ui.internal.ScoutSdkUi;
import org.eclipse.scout.sdk.ui.wizard.AbstractWorkspaceWizardPage;
import org.eclipse.scout.sdk.ws.jaxws.swt.wizard.page.ElementBean;
import org.eclipse.swt.widgets.Composite;

public class ResourceSelectionWizardPage
extends AbstractWorkspaceWizardPage {
    private CheckboxTableViewer m_tableViewer;
    private List<ElementBean> m_elements;

    public ResourceSelectionWizardPage(String title, String description) {
        super(ResourceSelectionWizardPage.class.getName());
        this.setTitle(title);
        this.setDescription(description);
    }

    protected void createContent(Composite parent) {
        this.m_tableViewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
        this.m_tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new P_LabelProvider());
        this.m_tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ElementBean element = (ElementBean)event.getElement();
                if (element.isMandatory()) {
                    ResourceSelectionWizardPage.this.m_tableViewer.setChecked((Object)element, true);
                } else {
                    element.setChecked(event.getChecked());
                }
            }
        });
        this.m_tableViewer.setInput(this.m_elements);
        LinkedList<ElementBean> checkedElements = new LinkedList<ElementBean>();
        for (ElementBean element : this.m_elements) {
            if (!element.isChecked()) continue;
            checkedElements.add(element);
        }
        this.m_tableViewer.setCheckedElements((Object[])checkedElements.toArray(new ElementBean[checkedElements.size()]));
    }

    public List<ElementBean> getElements() {
        return this.m_elements;
    }

    public void setElements(List<ElementBean> elements) {
        this.m_elements = elements;
    }

    private class P_LabelProvider
    extends CellLabelProvider {
        private P_LabelProvider() {
        }

        public void update(ViewerCell cell) {
            ElementBean element = (ElementBean)cell.getElement();
            cell.setText(element.getName());
            if (element.getImageDescriptor() != null) {
                cell.setImage(element.getImageDescriptor().createImage());
            } else {
                cell.setImage(null);
            }
            if (element.isMandatory()) {
                cell.setForeground(ScoutSdkUi.getDisplay().getSystemColor(18));
            }
        }
    }
}

