/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.svg.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.dom.svg.SAXSVGDocumentFactory;
import org.apache.batik.dom.svg.SVGOMRect;
import org.apache.batik.swing.svg.GVTTreeBuilder;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.svg.SVGAElement;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGElement;
import org.w3c.dom.svg.SVGPoint;
import org.w3c.dom.svg.SVGRect;
import org.w3c.dom.svg.SVGStylable;
import org.w3c.dom.svg.SVGTSpanElement;
import org.w3c.dom.svg.SVGTextContentElement;
import org.w3c.dom.svg.SVGTransform;
import org.w3c.dom.svg.SVGTransformList;
import org.w3c.dom.svg.SVGTransformable;

public final class SVGUtility {
    public static final String SVG_NS = "http://www.w3.org/2000/svg";
    public static final String XLINK_NS = "http://www.w3.org/1999/xlink";
    private static final float PIXEL_PER_POINT = 1.333333f;
    private static final float PIXEL_PER_MM = 3.779528f;
    private static final float PIXEL_PER_INCH = 96.0f;
    private static final float DEFAULT_FONT_HEIGHT = 14.0f;

    private SVGUtility() {
    }

    public static SVGDocument readSVGDocument(InputStream in) throws ProcessingException {
        SVGDocument doc;
        String cn;
        try {
            cn = Class.forName("org.apache.xerces.parsers.SAXParser").getName();
        }
        catch (Throwable t) {
            try {
                cn = Class.forName("com.sun.org.apache.xerces.internal.parsers.SAXParser").getName();
            }
            catch (Exception e) {
                throw new ProcessingException("Finding SAXParser", (Throwable)e);
            }
        }
        SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(cn);
        documentFactory.setValidating(false);
        try {
            doc = documentFactory.createSVGDocument(null, in);
        }
        catch (Exception e) {
            throw new ProcessingException("Reading SVG Failed", (Throwable)e);
        }
        try {
            doc.setDocumentURI("urn:svg");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return doc;
    }

    public static BridgeContext readSVGDocumentForGraphicalModification(InputStream in) throws ProcessingException {
        SVGDocument doc = SVGUtility.readSVGDocument(in);
        BridgeContext bc = new BridgeContext((UserAgent)new UserAgentAdapter());
        bc.setDynamic(true);
        GVTTreeBuilder treeBuilder = new GVTTreeBuilder(doc, bc);
        treeBuilder.setPriority(10);
        treeBuilder.run();
        return bc;
    }

    public static void writeSVGDocument(SVGDocument doc, OutputStream out, String encoding) throws ProcessingException {
        try {
            DOMSource domSource = new DOMSource((Node)doc);
            StreamResult streamResult = new StreamResult(out);
            Transformer t = TransformerFactory.newInstance().newTransformer();
            if (encoding != null) {
                t.setOutputProperty("encoding", encoding);
            }
            t.transform(domSource, streamResult);
            out.close();
        }
        catch (Exception e) {
            throw new ProcessingException("Writing SVG Failed", (Throwable)e);
        }
    }

    public static List<Element> getElementsAt(SVGDocument doc, SVGPoint point) {
        ArrayList<Element> list = new ArrayList<Element>();
        SVGOMRect svgOMRect = new SVGOMRect(point.getX(), point.getY(), 1.0f, 1.0f);
        NodeList intersectedElements = doc.getRootElement().getIntersectionList((SVGRect)svgOMRect, null);
        int n = intersectedElements.getLength();
        int i = 0;
        while (i < n) {
            Node node = intersectedElements.item(i);
            if (node instanceof Element) {
                list.add((Element)node);
            }
            ++i;
        }
        return list;
    }

    public static boolean visitDocument(Document doc, INodeVisitor v) throws Exception {
        return SVGUtility.visitNode(doc.getDocumentElement(), v);
    }

    public static boolean visitNode(Node parent, INodeVisitor v) throws Exception {
        NodeList nl = parent.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            boolean b = v.visit(nl.item(i));
            if (!b) {
                return false;
            }
            b = SVGUtility.visitNode(nl.item(i), v);
            if (!b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void setTransform(SVGElement e, float x, float y, float rotation) {
        SVGTransform tx;
        SVGTransformList list = ((SVGTransformable)e).getTransform().getBaseVal();
        list.clear();
        if (rotation != 0.0f) {
            tx = e.getOwnerSVGElement().createSVGTransform();
            tx.setRotate(rotation, 0.0f, 0.0f);
            list.appendItem(tx);
        }
        if (x != 0.0f || y != 0.0f) {
            tx = e.getOwnerSVGElement().createSVGTransform();
            tx.setTranslate(x, y);
            list.appendItem(tx);
        }
    }

    public static void setTextContent(Element e, String value, Float rowGap) {
        if (e == null) {
            return;
        }
        SVGTextContentElement textElement = (SVGTextContentElement)e;
        NodeList nl = textElement.getElementsByTagName("tspan");
        int i = 0;
        while (i < nl.getLength()) {
            nl.item(i).getParentNode().removeChild(nl.item(i));
            ++i;
        }
        if (value == null || value.length() == 0) {
            SVGUtility.setTextContent((Element)textElement, null);
            return;
        }
        if (!value.contains("\n")) {
            SVGUtility.setTextContent((Element)textElement, value);
            return;
        }
        float fontHeight = 0.0f;
        Object tmpNode = textElement;
        while (fontHeight == 0.0f && tmpNode != null) {
            String fontSizeText;
            if (tmpNode instanceof SVGStylable && (fontSizeText = ((SVGStylable)tmpNode).getStyle().getPropertyValue("font-size")) != null) {
                fontHeight = SVGUtility.convertToPx(fontSizeText);
                break;
            }
            tmpNode = tmpNode.getParentNode();
        }
        if (fontHeight == 0.0f) {
            fontHeight = 14.0f;
        }
        Float rGap = rowGap == null ? Float.valueOf(1.0f) : rowGap;
        float rowHeight = fontHeight + rGap.floatValue();
        float y = 0.0f;
        SVGUtility.setTextContent((Element)textElement, null);
        String[] stringArray = value.split("[\n\r]");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            SVGTSpanElement tspanElem = (SVGTSpanElement)textElement.getOwnerDocument().createElementNS(SVG_NS, "tspan");
            textElement.appendChild((Node)tspanElem);
            tspanElem.setTextContent(line);
            tspanElem.setAttribute("x", "0");
            tspanElem.setAttribute("y", String.valueOf(y));
            y += rowHeight;
            ++n2;
        }
    }

    public static void setTextContent(Element e, String textContent) {
        while (e.getFirstChild() != null) {
            e.removeChild(e.getFirstChild());
        }
        Text textNode = e.getOwnerDocument().createTextNode(textContent);
        e.appendChild(textNode);
    }

    public static String wrapText(SVGTextContentElement contextElement, String text, Float wordWrap) {
        if (text == null) {
            return "";
        }
        List<String> lines = Arrays.asList(text.split("[\n\r]"));
        if (wordWrap == null || wordWrap.floatValue() <= 0.0f || text.length() == 0) {
            return text;
        }
        float wrap = wordWrap.floatValue();
        ArrayList<String> wrappedLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            if (!StringUtility.hasText((String)line)) {
                wrappedLines.add("");
                continue;
            }
            line = line.replaceAll("[\\s]+", " ").trim();
            try {
                SVGUtility.setTextContent((Element)contextElement, line);
                float[] w = new float[line.length()];
                int i = 0;
                while (i < w.length) {
                    w[i] = contextElement.getExtentOfChar(i).getWidth();
                    ++i;
                }
                String[] words = line.split("[ ]");
                int startIndex = 0;
                int endIndex = 0;
                float acc = 0.0f;
                StringBuilder lineBuf = new StringBuilder();
                int wordIndex = 0;
                while (wordIndex < words.length) {
                    String word = words[wordIndex];
                    endIndex = startIndex + word.length();
                    float dw = 0.0f;
                    int i2 = startIndex;
                    while (i2 < endIndex) {
                        dw += w[i2];
                        ++i2;
                    }
                    if (lineBuf.length() > 0 && acc + dw > wrap) {
                        if (acc > wrap) {
                            wrappedLines.add(SVGUtility.rtrim(SVGUtility.clipText(contextElement, lineBuf.toString(), wrap)));
                        } else {
                            wrappedLines.add(SVGUtility.rtrim(lineBuf.toString()));
                        }
                        lineBuf.setLength(0);
                        acc = 0.0f;
                    }
                    acc += dw;
                    lineBuf.append(word);
                    if (endIndex < w.length) {
                        acc += w[endIndex];
                        lineBuf.append(" ");
                    }
                    startIndex = endIndex + 1;
                    ++wordIndex;
                }
                if (lineBuf.length() <= 0) continue;
                if (acc > wrap) {
                    wrappedLines.add(SVGUtility.rtrim(SVGUtility.clipText(contextElement, lineBuf.toString(), wrap)));
                } else {
                    wrappedLines.add(SVGUtility.rtrim(lineBuf.toString()));
                }
                lineBuf.setLength(0);
            }
            finally {
                SVGUtility.setTextContent((Element)contextElement, null);
            }
        }
        while (wrappedLines.size() > 0 && ((String)wrappedLines.get(wrappedLines.size() - 1)).length() == 0) {
            wrappedLines.remove(wrappedLines.size() - 1);
        }
        StringBuilder buf = new StringBuilder();
        int i = 0;
        int n = wrappedLines.size();
        while (i < n) {
            if (i > 0) {
                buf.append("\n");
            }
            buf.append((String)wrappedLines.get(i));
            ++i;
        }
        return buf.toString();
    }

    private static String rtrim(String s) {
        int len = s.length();
        int r = len - 1;
        while (r >= 0 && s.charAt(r) <= ' ') {
            --r;
        }
        if (r == len - 1) {
            return s;
        }
        if (r < 0) {
            return "";
        }
        return s.substring(0, r + 1);
    }

    public static String clipText(SVGTextContentElement contextElement, String text, float clipWidth) {
        if (text == null || text.length() == 0) {
            return text;
        }
        if (clipWidth <= 0.0f) {
            return text;
        }
        String suffix = "...";
        try {
            SVGUtility.setTextContent((Element)contextElement, String.valueOf(text) + suffix);
            int textLen = text.length();
            int suffixLen = suffix.length();
            float textWidth = 0.0f;
            float suffixWidth = 0.0f;
            float[] w = new float[textLen + suffixLen];
            int i = 0;
            while (i < w.length) {
                w[i] = contextElement.getExtentOfChar(i).getWidth();
                if (i < textLen) {
                    textWidth += w[i];
                } else {
                    suffixWidth += w[i];
                }
                ++i;
            }
            if (textWidth <= clipWidth) {
                String string = text;
                return string;
            }
            i = textLen - 1;
            while (i > 0 && textWidth + suffixWidth > clipWidth) {
                textWidth -= w[i];
                --i;
            }
            String string = String.valueOf(text.substring(0, i + 1)) + suffix;
            return string;
        }
        finally {
            SVGUtility.setTextContent((Element)contextElement, null);
        }
    }

    public static float getTextWidth(SVGTextContentElement contextElement, String text) {
        if (text == null || text.length() == 0) {
            return 0.0f;
        }
        try {
            SVGUtility.setTextContent((Element)contextElement, text);
            int textLen = text.length();
            float textWidth = 0.0f;
            int i = 0;
            while (i < textLen) {
                textWidth += contextElement.getExtentOfChar(i).getWidth();
                ++i;
            }
            float f = textWidth;
            return f;
        }
        finally {
            SVGUtility.setTextContent((Element)contextElement, null);
        }
    }

    private static float convertToPx(String valueWithUnit) {
        Matcher m = Pattern.compile("([0-9.]+)([^0-9.]*)").matcher(valueWithUnit);
        m.matches();
        float f = Float.valueOf(m.group(1)).floatValue();
        String unit = m.group(2);
        if (unit == null) {
            return f;
        }
        if ((unit = unit.toLowerCase()).equals("px")) {
            return f;
        }
        if (unit.equals("pt")) {
            return f * 1.333333f;
        }
        if (unit.equals("mm")) {
            return f * 3.779528f;
        }
        if (unit.equals("in")) {
            return f * 96.0f;
        }
        return f;
    }

    public static void addHyperlink(Element e, String url) {
        Attr a;
        Node node;
        SVGAElement aElem = (SVGAElement)e.getOwnerDocument().createElementNS(SVG_NS, "a");
        e.getParentNode().insertBefore((Node)aElem, e);
        e.getParentNode().removeChild(e);
        aElem.appendChild((Node)e);
        aElem.getHref().setBaseVal(url);
        NamedNodeMap nnmap = aElem.getAttributes();
        int i = 0;
        int n = nnmap.getLength();
        while (i < n) {
            node = nnmap.item(i);
            if (node instanceof Attr && XLINK_NS.equals((a = (Attr)node).getNamespaceURI()) && !"xlink".equals(a.getPrefix())) {
                nnmap.removeNamedItemNS(a.getNamespaceURI(), a.getLocalName());
                a.setPrefix("xlink");
                nnmap.setNamedItemNS(a);
            }
            ++i;
        }
        i = 0;
        n = nnmap.getLength();
        while (i < n) {
            node = nnmap.item(i);
            if (node instanceof Attr && "http://www.w3.org/2000/xmlns/".equals((a = (Attr)node).getNamespaceURI())) {
                nnmap.removeNamedItemNS(a.getNamespaceURI(), a.getLocalName());
            }
            ++i;
        }
    }

    public static interface INodeVisitor {
        public boolean visit(Node var1) throws Exception;
    }
}

