/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.commons;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class PublicKeyUtility {
    private PublicKeyUtility() {
    }

    public static byte[][] createKeyPair(String keyAlgorithm, int bitSize) throws NoSuchAlgorithmException {
        if (keyAlgorithm == null) {
            keyAlgorithm = "DSA";
        }
        KeyPairGenerator instance = KeyPairGenerator.getInstance(keyAlgorithm);
        if (bitSize > 0) {
            instance.initialize(bitSize);
        }
        KeyPair pair = instance.generateKeyPair();
        PrivateKey privKey = pair.getPrivate();
        PublicKey pubKey = pair.getPublic();
        byte[][] a = new byte[][]{pubKey.getEncoded(), privKey.getEncoded()};
        return a;
    }

    public static byte[] sign(byte[] data, byte[] privateKey, String keyAlgorithm, String signAlgorithm) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        if (keyAlgorithm == null) {
            keyAlgorithm = "DSA";
        }
        if (signAlgorithm == null) {
            signAlgorithm = "SHA1withDSA";
        }
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKey);
        KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
        PrivateKey privKey = keyFactory.generatePrivate(keySpec);
        Signature sign = Signature.getInstance(signAlgorithm);
        sign.initSign(privKey);
        sign.update(data);
        byte[] signatureData = sign.sign();
        return signatureData;
    }

    public static boolean verify(byte[] data, byte[] publicKey, byte[] signatureData, String keyAlgorithm, String signAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        if (keyAlgorithm == null) {
            keyAlgorithm = "DSA";
        }
        if (signAlgorithm == null) {
            signAlgorithm = "SHA1withDSA";
        }
        if (data == null || signatureData == null) {
            return false;
        }
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKey);
        KeyFactory keyFactory = KeyFactory.getInstance(keyAlgorithm);
        PublicKey pubKey = keyFactory.generatePublic(keySpec);
        Signature sign = Signature.getInstance(signAlgorithm);
        sign.initVerify(pubKey);
        sign.update(data);
        boolean ok = sign.verify(signatureData);
        return ok;
    }
}

