/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.scout.commons.beans.BasicPropertySupport;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.simple.internal.NlsSdkSimple;
import org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile.PlatformNlsFile;
import org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile.WorkspaceNlsFile;

public abstract class AbstractNlsFile {
    private static final String PROP_NLS_TYPE_NAME = "nlsTypeName";
    public static final String MANIFEST_CLASS = "Nls-Class";
    private final BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);
    private final IProject m_project;

    protected AbstractNlsFile(IFile file) {
        this.m_project = file.getProject();
        this.parseInput(file);
    }

    public abstract boolean isReadOnly();

    public static AbstractNlsFile loadNlsFile(IFile file) throws CoreException {
        AbstractNlsFile nlsFile = null;
        if (file != null && file.exists()) {
            nlsFile = file.isReadOnly() ? new PlatformNlsFile(file) : new WorkspaceNlsFile(file);
        }
        return nlsFile;
    }

    protected void parseInput(IFile file) {
        Properties props;
        block14: {
            props = new Properties();
            InputStream io = null;
            try {
                try {
                    io = file.getContents();
                    props.load(io);
                }
                catch (Exception e) {
                    NlsCore.logWarning((String)("could not open stream to read NLS file :'" + file.getFullPath() + "'"), (Throwable)e);
                    if (io != null) {
                        try {
                            io.close();
                        }
                        catch (IOException e2) {
                            NlsSdkSimple.logWarning("could not close input stream of '" + file.getFullPath() + "'.", e2);
                        }
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (io != null) {
                    try {
                        io.close();
                    }
                    catch (IOException e) {
                        NlsSdkSimple.logWarning("could not close input stream of '" + file.getFullPath() + "'.", e);
                    }
                }
                throw throwable;
            }
            if (io != null) {
                try {
                    io.close();
                }
                catch (IOException e) {
                    NlsSdkSimple.logWarning("could not close input stream of '" + file.getFullPath() + "'.", e);
                }
            }
        }
        this.m_propertySupport.setPropertyString(PROP_NLS_TYPE_NAME, props.getProperty(MANIFEST_CLASS));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public String getNlsTypeName() {
        return this.m_propertySupport.getPropertyString(PROP_NLS_TYPE_NAME);
    }

    public IProject getProject() {
        return this.m_project;
    }
}

