/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.simple.model.ws.project;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.scout.nls.sdk.extension.INlsProjectProvider;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.model.workspace.project.INlsProject;
import org.eclipse.scout.nls.sdk.simple.model.ws.NlsType;
import org.eclipse.scout.nls.sdk.simple.model.ws.nlsfile.AbstractNlsFile;
import org.eclipse.scout.nls.sdk.simple.model.ws.project.SimpleNlsProject;
import org.eclipse.scout.sdk.util.type.TypeUtility;

public class SimpleNlsProjectProvider
implements INlsProjectProvider {
    private final HashMap<String, INlsProject> m_projects = new HashMap();
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected INlsProject getNlsProject(IType type) throws CoreException {
        if (!TypeUtility.exists((IJavaElement)type)) {
            NlsCore.logError((String)("nls type '" + type.getFullyQualifiedName() + "' does not exist"));
            return null;
        }
        Object object = LOCK;
        synchronized (object) {
            NlsType t;
            Object nlsProject = this.m_projects.get(type.getFullyQualifiedName());
            if (nlsProject == null && (t = new NlsType(type)) != null && t.getTranslationsFolderName() != null) {
                nlsProject = new SimpleNlsProject(t);
                this.m_projects.put(type.getFullyQualifiedName(), (INlsProject)nlsProject);
            }
            return nlsProject;
        }
    }

    public INlsProject getProject(Object[] args) {
        block9: {
            if (args != null && args.length == 1) {
                IFile f;
                if (args[0] instanceof IType) {
                    IType t = (IType)args[0];
                    try {
                        return this.getNlsProject(t);
                    }
                    catch (CoreException e) {
                        NlsCore.logWarning((String)("Could not load NlsType: " + t.getFullyQualifiedName()), (Throwable)e);
                        break block9;
                    }
                }
                if (args[0] instanceof IFile && (f = (IFile)args[0]).getName().toLowerCase().endsWith(".nls")) {
                    try {
                        AbstractNlsFile nlsFile = AbstractNlsFile.loadNlsFile(f);
                        if (PluginRegistry.findModel((IProject)nlsFile.getProject()) != null && nlsFile.getNlsTypeName() != null) {
                            IType type = TypeUtility.getType((String)nlsFile.getNlsTypeName());
                            INlsProject simpleProj = this.getNlsProject(type);
                            if (simpleProj != null) {
                                return simpleProj;
                            }
                            return NlsCore.getNlsWorkspace().getNlsProject(new Object[]{type});
                        }
                    }
                    catch (CoreException e) {
                        NlsCore.logWarning((String)("Could not load NlsFile: " + f.getFullPath().toString()), (Throwable)e);
                    }
                }
            }
        }
        return null;
    }
}

