/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.action;

import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.ui.action.AbstractNlsProposal;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class NlsProposal
extends AbstractNlsProposal {
    private final INlsEntry m_nlsEntry;
    private final Image m_image;

    public NlsProposal(INlsEntry nlsEntry, String prefix, int initialOffset, Image image) {
        super(prefix, initialOffset);
        this.m_nlsEntry = nlsEntry;
        this.m_image = image;
    }

    @Override
    public int getRelevance() {
        return 1;
    }

    @Override
    public String getAdditionalProposalInfo() {
        Map<Language, String> allTranslations = this.m_nlsEntry.getAllTranslations();
        if (allTranslations != null && allTranslations.size() > 0) {
            StringBuilder b = new StringBuilder();
            for (Map.Entry<Language, String> e : allTranslations.entrySet()) {
                b.append("'<b>" + e.getValue().replace("\n", "<br>") + "</b>' [" + e.getKey().getDispalyName() + "]<br>");
            }
            return b.toString();
        }
        return null;
    }

    public String getDisplayString() {
        return this.m_nlsEntry.getKey();
    }

    public Image getImage() {
        return this.m_image;
    }

    @Override
    public IContextInformation getContextInformation() {
        return null;
    }

    @Override
    public void apply(IDocument document, char trigger, int offset) {
        try {
            this.replaceWith(document, offset, this.m_nlsEntry.getKey());
        }
        catch (BadLocationException e) {
            NlsCore.logError(e);
        }
    }

    @Override
    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        if (super.validate(document, offset, event)) {
            try {
                Point keyRange = this.findKeyRange(document, offset);
                String prefix = document.get(keyRange.x, offset - keyRange.x);
                return this.m_nlsEntry.getKey().toLowerCase().startsWith(prefix.toLowerCase());
            }
            catch (BadLocationException e) {
                NlsCore.logWarning(e);
                return false;
            }
        }
        return false;
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.m_nlsEntry.getKey();
    }

    @Override
    public boolean isAutoInsertable() {
        return true;
    }
}

