/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class NlsFilterComponent
extends Composite {
    private TableViewer m_tableViewer;
    private final Button m_resetButton;
    private final HashMap<Language, Text> m_filterFields = new HashMap();

    public NlsFilterComponent(Composite parent) {
        super(parent, 0x20000000);
        this.setBackground(parent.getBackground());
        this.m_resetButton = new Button((Composite)this, 0x800008);
        this.m_resetButton.setText("Reset");
        this.m_resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Text t : NlsFilterComponent.this.m_filterFields.values()) {
                    t.setText("");
                }
            }
        });
        this.updateFilterFields(this);
        this.setLayout(new P_FilterComponentLayout());
    }

    public void setTableViewer(TableViewer tableViewer) {
        this.m_tableViewer = tableViewer;
        this.m_tableViewer.getTable().addListener(9, new Listener(){

            public void handleEvent(Event event) {
                NlsFilterComponent.this.layout();
            }
        });
        this.updateFilterFields(this);
    }

    public void columnsChanged() {
        this.updateFilterFields(this);
    }

    protected void updateFilterFields(Composite parent) {
        HashMap<Language, String> oldContents = new HashMap<Language, String>(this.m_filterFields.size());
        if (!this.m_filterFields.isEmpty()) {
            for (Map.Entry<Language, Text> entry : this.m_filterFields.entrySet()) {
                oldContents.put(entry.getKey(), entry.getValue().getText());
                entry.getValue().dispose();
            }
            this.m_filterFields.clear();
        }
        if (this.m_tableViewer != null && this.m_tableViewer.getTable().getColumnCount() > 1) {
            TableColumn[] columns = this.m_tableViewer.getTable().getColumns();
            int i = 1;
            while (i < columns.length) {
                Language l = (Language)columns[i].getData("columnIdentifierLanguage");
                Text filterField = new Text((Composite)this, 2048);
                filterField.addModifyListener((ModifyListener)new P_FilterModifyListener(i));
                String oldText = (String)oldContents.get(l);
                if (oldText != null) {
                    filterField.setText(oldText);
                }
                this.m_filterFields.put(l, filterField);
                ++i;
            }
        }
    }

    protected void handleFilterModified(int index) {
        ArrayList<ViewerFilter> filters = new ArrayList<ViewerFilter>();
        ViewerFilter[] viewerFilterArray = this.m_tableViewer.getFilters();
        int n = viewerFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerFilter filter = viewerFilterArray[n2];
            if (!(filter instanceof P_ViewerFilter)) {
                filters.add(filter);
            }
            ++n2;
        }
        for (Map.Entry<Language, Text> e : this.m_filterFields.entrySet()) {
            if (e.getValue().getText().length() <= 0) continue;
            filters.add(new P_ViewerFilter(e.getKey(), e.getValue().getText()));
        }
        try {
            this.m_tableViewer.getTable().setRedraw(false);
            this.m_tableViewer.setFilters(filters.toArray(new ViewerFilter[filters.size()]));
        }
        finally {
            this.m_tableViewer.getTable().setRedraw(true);
        }
    }

    private class P_FilterComponentLayout
    extends Layout {
        private P_FilterComponentLayout() {
        }

        protected Point computeSize(Composite composite, int hint, int hint2, boolean flushCache) {
            int height = ((NlsFilterComponent)NlsFilterComponent.this).m_resetButton.computeSize((int)-1, (int)hint2).y + 2;
            for (Text t : NlsFilterComponent.this.m_filterFields.values()) {
                height = Math.max(height, t.computeSize((int)-1, (int)hint2).y + 2);
            }
            return new Point(hint, height);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle parentBounds = composite.getClientArea();
            TableColumn[] columns = NlsFilterComponent.this.m_tableViewer.getTable().getColumns();
            int[] colOrder = NlsFilterComponent.this.m_tableViewer.getTable().getColumnOrder();
            int x = -NlsFilterComponent.this.m_tableViewer.getTable().getHorizontalBar().getSelection();
            int i = 0;
            while (i < columns.length) {
                TableColumn column = columns[colOrder[i]];
                if (i == 1) {
                    NlsFilterComponent.this.m_resetButton.setBounds(1, 1, x - 2, parentBounds.height - 2);
                }
                if (i >= 1) {
                    Language lang = (Language)column.getData("columnIdentifierLanguage");
                    Text text = (Text)NlsFilterComponent.this.m_filterFields.get(lang);
                    if (text != null) {
                        text.setBounds(x + 1, 1, column.getWidth() - 2, parentBounds.height - 2);
                    }
                }
                x += column.getWidth();
                ++i;
            }
            composite.update();
        }
    }

    private class P_FilterModifyListener
    implements ModifyListener {
        private int m_columnIndex;

        public P_FilterModifyListener(int columnIndex) {
            this.m_columnIndex = columnIndex;
        }

        public void modifyText(ModifyEvent e) {
            NlsFilterComponent.this.handleFilterModified(this.m_columnIndex);
        }
    }

    private class P_ViewerFilter
    extends ViewerFilter {
        private final String m_pattern;
        private final Language m_lang;

        public P_ViewerFilter(Language lang, String pattern) {
            this.m_lang = lang;
            this.m_pattern = String.valueOf(pattern.toLowerCase()) + "*";
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            INlsEntry nlsEntry = (INlsEntry)element;
            String text = this.m_lang == Language.LANGUAGE_KEY ? nlsEntry.getKey() : nlsEntry.getTranslation(this.m_lang);
            if (text == null) {
                text = "";
            }
            text = text.replace("&", "");
            return CharOperation.match((char[])this.m_pattern.toCharArray(), (char[])text.toCharArray(), (boolean)false);
        }
    }
}

