/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.nls.sdk.internal.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.nls.sdk.internal.NlsCore;
import org.eclipse.scout.nls.sdk.internal.model.workspace.InheritedNlsEntry;
import org.eclipse.scout.nls.sdk.internal.ui.TableTextEditor;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTable;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTableInputValidator;
import org.eclipse.scout.nls.sdk.internal.ui.editor.NlsTableSelection;
import org.eclipse.scout.nls.sdk.model.INlsEntry;
import org.eclipse.scout.nls.sdk.model.util.Language;
import org.eclipse.scout.nls.sdk.model.workspace.NlsEntry;
import org.eclipse.scout.nls.sdk.ui.INlsTableCursorManangerListener;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class NlsTableCursor {
    private final Table m_table;
    private final TableCursor m_cursor;
    private final List<INlsTableCursorManangerListener> m_listeners;
    private final NlsTable m_nlsTable;
    private NlsTableInputValidator m_inputValidator;
    private boolean m_renaming;
    private TableTextEditor m_editingText;

    public NlsTableCursor(Table table, NlsTable nlsTable) {
        this.m_table = table;
        this.m_cursor = new TableCursor(this.m_table, 0);
        this.m_cursor.setBackgroundMode(2);
        this.m_listeners = new ArrayList<INlsTableCursorManangerListener>();
        this.m_nlsTable = nlsTable;
        this.m_cursor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                NlsTableCursor.this.m_cursor.setForeground(NlsCore.getColor("color_table_cursor_foreground"));
                NlsTableCursor.this.m_cursor.setBackground(NlsCore.getColor("color_table_cursor_background"));
            }

            public void focusLost(FocusEvent e) {
                NlsTableCursor.this.m_cursor.setBackground(NlsCore.getColor("color_table_cursor_inactive_background"));
                NlsTableCursor.this.m_cursor.setForeground(NlsCore.getColor("color_table_cursor_inactive_foreground"));
            }
        });
        this.m_cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                NlsTableCursor.this.createEditableText();
            }
        });
        this.m_cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.stateMask) {
                    case 65536: 
                    case 262144: {
                        return;
                    }
                }
                if (e.keyCode == 0x100000B) {
                    NlsTableCursor.this.createEditableText();
                } else {
                    String input = new String(new char[]{e.character});
                    String pattern = "[a-zA-Z0-9]";
                    if (input.matches(pattern) && NlsTableCursor.this.m_cursor.getColumn() > 1) {
                        NlsTableCursor.this.createEditableText(new String(new char[]{e.character}));
                    }
                }
            }
        });
        this.m_cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object rowData = ((TableCursor)e.getSource()).getRow().getData();
                if (rowData == null) {
                    return;
                }
                if (rowData instanceof InheritedNlsEntry) {
                    NlsTableCursor.this.m_cursor.setForeground(NlsCore.getColor("nlsRowInactiveForeground"));
                    NlsTableCursor.this.m_cursor.setBackground(NlsCore.getColor("color_table_cursor_inactive_background"));
                } else {
                    NlsTableCursor.this.m_cursor.setForeground(NlsCore.getColor("color_table_cursor_foreground"));
                    NlsTableCursor.this.m_cursor.setBackground(NlsCore.getColor("color_table_cursor_background"));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NlsTableCursor.this.createEditableText();
            }
        });
    }

    private void showInheritedWarning() {
    }

    public TableCursor getCursor() {
        return this.m_cursor;
    }

    public void setInputValidator(NlsTableInputValidator validator) {
        this.m_inputValidator = validator;
    }

    public NlsTableSelection getSelection() {
        NlsEntry row = (NlsEntry)this.m_cursor.getRow().getData();
        if (row == null) {
            return null;
        }
        return new NlsTableSelection(row, this.m_cursor.getColumn());
    }

    public void addKeyListener(KeyListener listener) {
        this.m_cursor.addKeyListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.m_cursor.removeKeyListener(listener);
    }

    public void addCursorMangerListener(INlsTableCursorManangerListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeCursorMangerListener(INlsTableCursorManangerListener listener) {
        this.m_listeners.remove(listener);
    }

    public void ensureFocus(TableItem row) {
        this.m_cursor.setSelection(row, 1);
        this.m_cursor.setVisible(true);
        this.m_cursor.setFocus();
    }

    public void setEditableText(int rowIndex, int column) {
        this.m_cursor.setSelection(rowIndex, column);
        this.createEditableText();
    }

    public void createEditableText() {
        this.createEditableText(null);
    }

    public void createEditableText(String input) {
        if (this.m_cursor.getRow().getData() instanceof InheritedNlsEntry) {
            this.showInheritedWarning();
            return;
        }
        if (this.m_cursor.getColumn() < 1) {
            return;
        }
        if (this.m_nlsTable.getModel() != null && this.m_nlsTable.getModel().getProjects() != null && this.m_nlsTable.getModel().getProjects().isReadOnly()) {
            return;
        }
        this.createEditableTextInternal(input);
    }

    private void createEditableTextInternal(String defaultText) {
        if (this.m_editingText != null && !this.m_editingText.isDisposed()) {
            this.m_editingText.dispose();
        }
        int style = 770;
        if (this.m_cursor.getColumn() == 1) {
            style = 0;
        }
        this.m_editingText = new TableTextEditor(this.m_cursor, style);
        INlsEntry entry = (INlsEntry)this.m_cursor.getRow().getData();
        Language[] allLangs = entry.getProject().getAllLanguages();
        int langIndex = this.m_cursor.getColumn() - 2;
        String input = null;
        if (langIndex >= 0 && langIndex < allLangs.length) {
            Language lang = allLangs[langIndex];
            input = entry.getTranslation(lang);
        } else {
            input = this.m_cursor.getRow().getText(this.m_cursor.getColumn());
        }
        if (defaultText != null) {
            input = defaultText;
        }
        if (input == null) {
            input = "";
        }
        this.m_editingText.setText(input);
        this.m_editingText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (NlsTableCursor.this.m_inputValidator.validate(NlsTableCursor.this.m_editingText.getText(), NlsTableCursor.this.m_cursor.getColumn()).isOK()) {
                    NlsTableCursor.this.m_editingText.setForeground(null);
                } else {
                    NlsTableCursor.this.m_editingText.setForeground(NlsTableCursor.this.m_editingText.getDisplay().getSystemColor(3));
                }
            }
        });
        if (defaultText != null) {
            this.m_editingText.setSelection(input.length());
        } else {
            this.m_editingText.setSelection(0, input.length());
        }
        this.m_editingText.addKeyListener((KeyListener)new KeyAdapter(){
            private boolean m_altPressed = false;

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 65536) {
                    this.m_altPressed = false;
                }
            }

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 27: {
                        NlsTableCursor.this.disposeText();
                        break;
                    }
                    case 65536: {
                        this.m_altPressed = true;
                        break;
                    }
                    case 13: {
                        if (this.m_altPressed) {
                            if (NlsTableCursor.this.getCursor().getColumn() == 1) break;
                            NlsTableCursor.this.addNewLine();
                            break;
                        }
                        NlsTableCursor.this.storeText();
                    }
                }
            }
        });
        this.m_editingText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (NlsTableCursor.this.m_renaming) {
                    return;
                }
                NlsTableCursor.this.storeText();
            }
        });
        this.m_editingText.open();
        this.m_editingText.setFocus();
    }

    private void disposeText() {
        this.m_editingText.dispose();
        this.m_editingText = null;
    }

    private void addNewLine() {
        if (this.m_editingText == null || this.m_editingText.isDisposed()) {
            return;
        }
        this.m_editingText.insertText("\n");
    }

    private void storeText() {
        if (this.m_editingText == null || this.m_editingText.isDisposed()) {
            return;
        }
        int column = this.m_cursor.getColumn();
        if (!this.m_inputValidator.validate(this.m_editingText.getText(), column).isOK()) {
            this.disposeText();
            return;
        }
        this.m_renaming = true;
        try {
            INlsEntry row = (INlsEntry)this.m_cursor.getRow().getData();
            for (INlsTableCursorManangerListener listener : this.m_listeners) {
                listener.textChangend(row, this.m_cursor.getColumn(), this.m_editingText.getText());
            }
        }
        finally {
            this.disposeText();
            this.m_renaming = false;
        }
    }
}

