/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.mobile.ui.desktop;

import java.util.List;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.IHolder;
import org.eclipse.scout.rt.client.mobile.navigation.AbstractMobileBackAction;
import org.eclipse.scout.rt.client.mobile.navigation.AbstractMobileHomeAction;
import org.eclipse.scout.rt.client.mobile.navigation.IBreadCrumbsNavigationService;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformationService;
import org.eclipse.scout.rt.client.mobile.transformation.IDeviceTransformer;
import org.eclipse.scout.rt.client.ui.action.IAction;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.desktop.AbstractDesktopExtension;
import org.eclipse.scout.rt.client.ui.desktop.ContributionCommand;
import org.eclipse.scout.rt.client.ui.desktop.IDesktop;
import org.eclipse.scout.rt.client.ui.desktop.outline.IOutline;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.IPageWithTable;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.ui.UserAgentUtility;
import org.eclipse.scout.service.SERVICES;

public class DeviceTransformationDesktopExtension
extends AbstractDesktopExtension {
    private boolean m_active;
    private IDeviceTransformer m_deviceTransformer;

    public DeviceTransformationDesktopExtension() {
        this.setActive(UserAgentUtility.isTouchDevice());
    }

    public boolean isActive() {
        return this.m_active;
    }

    public void setActive(boolean active) {
        this.m_active = active;
    }

    public void setCoreDesktop(IDesktop desktop) {
        super.setCoreDesktop(desktop);
        if (this.isActive()) {
            ((IBreadCrumbsNavigationService)SERVICES.getService(IBreadCrumbsNavigationService.class)).install(this.getCoreDesktop());
            ((IDeviceTransformationService)SERVICES.getService(IDeviceTransformationService.class)).install(this.getCoreDesktop());
        }
    }

    public IDeviceTransformer getDeviceTransformer() {
        if (this.m_deviceTransformer == null) {
            this.m_deviceTransformer = ((IDeviceTransformationService)SERVICES.getService(IDeviceTransformationService.class)).getDeviceTransformer();
        }
        return this.m_deviceTransformer;
    }

    protected ContributionCommand execInit() throws ProcessingException {
        if (!this.isActive()) {
            return super.execInit();
        }
        return ContributionCommand.Continue;
    }

    public void contributeActions(List<IAction> actions) {
        if (!this.isActive()) {
            return;
        }
        this.getDeviceTransformer().adaptDesktopActions(actions);
        super.contributeActions(actions);
    }

    public void contributeOutlines(List<IOutline> outlines) {
        if (!this.isActive()) {
            return;
        }
        this.getDeviceTransformer().adaptDesktopOutlines(outlines);
        super.contributeOutlines(outlines);
    }

    protected ContributionCommand execOutlineChanged(IOutline oldOutline, IOutline newOutline) throws ProcessingException {
        if (!this.isActive()) {
            return super.execOutlineChanged(oldOutline, newOutline);
        }
        this.getDeviceTransformer().transformOutline(newOutline);
        return ContributionCommand.Continue;
    }

    protected ContributionCommand execPageDetailTableChanged(ITable oldTable, ITable newTable) throws ProcessingException {
        if (!this.isActive()) {
            return super.execPageDetailTableChanged(oldTable, newTable);
        }
        this.getDeviceTransformer().transformPageDetailTable(newTable);
        return ContributionCommand.Continue;
    }

    protected ContributionCommand execCustomFormModification(IHolder<IForm> formHolder) {
        if (!this.isActive()) {
            return super.execCustomFormModification(formHolder);
        }
        IForm form = (IForm)formHolder.getValue();
        if (form == null) {
            return ContributionCommand.Stop;
        }
        try {
            this.getDeviceTransformer().transformForm(form);
        }
        catch (ProcessingException e) {
            ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
        }
        if (!this.getDeviceTransformer().acceptFormAddingToDesktop(form)) {
            formHolder.setValue(null);
            return ContributionCommand.Stop;
        }
        return ContributionCommand.Continue;
    }

    protected ContributionCommand execTablePageLoaded(IPageWithTable<?> tablePage) throws ProcessingException {
        if (!this.isActive()) {
            return super.execTablePageLoaded(tablePage);
        }
        this.getDeviceTransformer().notifyTablePageLoaded(tablePage);
        return ContributionCommand.Continue;
    }

    @Order(value=10.0)
    public class BackAction
    extends AbstractMobileBackAction {
        protected boolean getConfiguredVisible() {
            return false;
        }
    }

    @Order(value=20.0)
    public class HomeAction
    extends AbstractMobileHomeAction {
        @Override
        protected boolean getConfiguredVisible() {
            return false;
        }
    }
}

