/*******************************************************************************
 * Copyright (c) 2010 BSI Business Systems Integration AG.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     BSI Business Systems Integration AG - initial API and implementation
 ******************************************************************************/
package org.eclipse.scout.rt.client.ui.action.menu.checkbox;

import org.eclipse.scout.rt.client.ui.action.menu.AbstractMenu;

public abstract class AbstractCheckBoxMenu extends AbstractMenu implements ICheckBoxMenu {

  private boolean m_supportedChangeToggleBehaviour;

  public AbstractCheckBoxMenu() {
    super();
  }

  public AbstractCheckBoxMenu(boolean callInitializer) {
    super(callInitializer);
  }

  @Override
  protected void initConfig() {
    // enable setToggleAction for super init
    try {
      m_supportedChangeToggleBehaviour = true;
      super.initConfig();
    }
    finally {
      m_supportedChangeToggleBehaviour = false;
    }
  }

  @Override
  protected final boolean getConfiguredToggleAction() {
    return true;
  }

  @Override
  public final void setToggleAction(boolean b) {
    if (m_supportedChangeToggleBehaviour) {
      super.setToggleAction(b);
    }
    else {
      throw new UnsupportedOperationException("setToggleAction on " + AbstractCheckBoxMenu.class.getSimpleName() + " is not supported!");
    }
    // void here
  }

}
