/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.services.common.search;

import org.eclipse.scout.rt.client.ClientJob;
import org.eclipse.scout.rt.client.services.common.search.DefaultSearchFilterService;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.AbstractComposerField;
import org.eclipse.scout.rt.client.ui.form.fields.composer.internal.TokenBasedComposerStatementBuilder;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.AbstractStringField;
import org.eclipse.scout.rt.shared.services.common.jdbc.SearchFilter;
import org.eclipse.scout.rt.shared.services.common.jdbc.TokenBasedSearchFilter;

public class TokenBasedSearchFilterService
extends DefaultSearchFilterService {
    @Override
    public SearchFilter createNewSearchFilter() {
        return new TokenBasedSearchFilter();
    }

    public Integer resolveTokenIdByClass(Class<?> source) {
        throw new IllegalArgumentException("subclass should implement this method the resolve type to tokenId");
    }

    @Override
    public void applySearchDelegate(IFormField field, SearchFilter search, boolean includeChildren) {
        if (search instanceof TokenBasedSearchFilter) {
            this.applyInterceptor(field, (TokenBasedSearchFilter)search);
        }
        super.applySearchDelegate(field, search, includeChildren);
    }

    protected void applyInterceptor(IFormField field, TokenBasedSearchFilter search) {
        if (field instanceof AbstractComposerField) {
            TokenBasedSearchFilter.AndNodeToken rootTok;
            AbstractComposerField composerField = (AbstractComposerField)field;
            ITreeNode rootNode = composerField.getTree().getRootNode();
            if (rootNode != null && (rootTok = new TokenBasedComposerStatementBuilder(this).build(rootNode)) != null) {
                search.addTreeToken(rootTok);
            }
            return;
        }
        if (field instanceof AbstractStringField) {
            AbstractStringField valueField = (AbstractStringField)field;
            String value = (String)valueField.getValue();
            if (value != null) {
                if (ClientJob.getCurrentSession().getDesktop().isAutoPrefixWildcardForTextSearch()) {
                    value = "*" + value;
                }
                search.addWildcardStringToken(this.resolveTokenIdByClass(field.getClass()), value);
            }
            return;
        }
        if (field instanceof AbstractValueField) {
            AbstractValueField valueField = (AbstractValueField)field;
            if (valueField.getValue() != null) {
                search.addToken(this.resolveTokenIdByClass(field.getClass()), new Object[]{valueField.getValue()});
            }
            return;
        }
    }
}

