/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.scout.commons.ITypeWithClassId;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.IDNDSupport;
import org.eclipse.scout.rt.client.ui.IEventHistory;
import org.eclipse.scout.rt.client.ui.action.keystroke.IKeyStroke;
import org.eclipse.scout.rt.client.ui.action.menu.IMenu;
import org.eclipse.scout.rt.client.ui.action.menu.root.ITableContextMenu;
import org.eclipse.scout.rt.client.ui.basic.cell.ICell;
import org.eclipse.scout.rt.client.ui.basic.table.ColumnSet;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowDataMapper;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRowFilter;
import org.eclipse.scout.rt.client.ui.basic.table.ITableUIFacade;
import org.eclipse.scout.rt.client.ui.basic.table.TableEvent;
import org.eclipse.scout.rt.client.ui.basic.table.TableListener;
import org.eclipse.scout.rt.client.ui.basic.table.columnfilter.ITableColumnFilterManager;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.customizer.ITableCustomizer;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldBeanData;
import org.eclipse.scout.rt.shared.data.form.fields.tablefield.AbstractTableFieldData;

public interface ITable
extends IPropertyObserver,
IDNDSupport,
ITypeWithClassId {
    public static final String PROP_TITLE = "title";
    public static final String PROP_ENABLED = "enabled";
    public static final String PROP_DEFAULT_ICON = "defaultIcon";
    public static final String PROP_MULTI_SELECT = "multiSelect";
    public static final String PROP_MULTI_CHECK = "multiCheck";
    public static final String PROP_MULTILINE_TEXT = "multilineText";
    public static final String PROP_ROW_HEIGHT_HINT = "rowHeightHint";
    public static final String PROP_CHECKABLE = "checkable";
    public static final String PROP_HEADER_VISIBLE = "headerVisible";
    public static final String PROP_KEYBOARD_NAVIGATION = "keyboardNavigation";
    public static final String PROP_AUTO_RESIZE_COLUMNS = "autoResizeColumns";
    public static final String PROP_CONTEXT_COLUMN = "contextColumn";
    public static final String PROP_COLUMN_FILTER_MANAGER = "columnFilterManger";
    public static final String PROP_KEY_STROKES = "keyStroks";
    public static final String PROP_SCROLL_TO_SELECTION = "scrollToSelection";
    public static final String PROP_CONTAINER = "container";
    public static final String PROP_CONTEXT_MENU = "contextMenus";
    public static final String LOCAL_URL_HOST = "local";
    public static final String LOCAL_URL_PREFIX = "http://local/";
    public static final String PROP_TABLE_CUSTOMIZER = "tableCustomizer";

    public void initTable() throws ProcessingException;

    public void disposeTable();

    public void doHyperlinkAction(ITableRow var1, IColumn<?> var2, URL var3) throws ProcessingException;

    public List<ITableRowFilter> getRowFilters();

    public void addRowFilter(ITableRowFilter var1);

    public void removeRowFilter(ITableRowFilter var1);

    public void applyRowFilters();

    public String getTitle();

    public void setTitle(String var1);

    public String getUserPreferenceContext();

    public void setUserPreferenceContext(String var1);

    public boolean isAutoResizeColumns();

    public void setAutoResizeColumns(boolean var1);

    public int getColumnCount();

    public List<IColumn<?>> getColumns();

    public List<String> getColumnNames();

    public int getVisibleColumnCount();

    public ColumnSet getColumnSet();

    public int getRowCount();

    public ITableRow getRow(int var1);

    public List<ITableRow> getRows(int[] var1);

    public List<ITableRow> getRows();

    public List<ITableRow> getFilteredRows();

    public int getFilteredRowCount();

    public ITableRow getFilteredRow(int var1);

    public int getFilteredRowIndex(ITableRow var1);

    public Object[][] getTableData();

    public Object[][] exportTableRowsAsCSV(List<? extends ITableRow> var1, List<? extends IColumn> var2, boolean var3, boolean var4, boolean var5);

    public int getInsertedRowCount();

    public List<ITableRow> getInsertedRows();

    public int getUpdatedRowCount();

    public List<ITableRow> getUpdatedRows();

    public int getDeletedRowCount();

    public List<ITableRow> getDeletedRows();

    public int getNotDeletedRowCount();

    public List<ITableRow> getNotDeletedRows();

    public List<Object> getRowKeys(int var1);

    public List<Object> getRowKeys(ITableRow var1);

    public ITableRow findRowByKey(List<?> var1);

    public void extractTableData(AbstractTableFieldData var1) throws ProcessingException;

    public void updateTable(AbstractTableFieldData var1) throws ProcessingException;

    public <T extends IMenu> T getMenu(Class<T> var1) throws ProcessingException;

    public List<IKeyStroke> getKeyStrokes();

    public void setKeyStrokes(List<? extends IKeyStroke> var1);

    public boolean runMenu(Class<? extends IMenu> var1) throws ProcessingException;

    public boolean isScrollToSelection();

    public void setScrollToSelection(boolean var1);

    public void scrollToSelection();

    public IHeaderCell getVisibleHeaderCell(int var1);

    public IHeaderCell getHeaderCell(int var1);

    public IHeaderCell getHeaderCell(IColumn<?> var1);

    public ICell getVisibleCell(ITableRow var1, int var2);

    public ICell getVisibleCell(int var1, int var2);

    public ICell getCell(int var1, int var2);

    public ICell getCell(ITableRow var1, IColumn<?> var2);

    public ICell getSummaryCell(int var1);

    public ICell getSummaryCell(ITableRow var1);

    public boolean isCellEditable(int var1, int var2);

    public boolean isCellEditable(ITableRow var1, int var2);

    public boolean isCellEditable(ITableRow var1, IColumn<?> var2);

    public Object getProperty(String var1);

    public void setProperty(String var1, Object var2);

    public boolean hasProperty(String var1);

    public boolean isCheckable();

    public void setCheckable(boolean var1);

    public boolean isHeaderVisible();

    public void setHeaderVisible(boolean var1);

    public boolean isMultilineText();

    public void setMultilineText(boolean var1);

    public int getRowHeightHint();

    public void setRowHeightHint(int var1);

    public boolean isInitialMultilineText();

    public void setInitialMultilineText(boolean var1);

    public boolean hasKeyboardNavigation();

    public void setKeyboardNavigation(boolean var1);

    public boolean isMultiSelect();

    public void setMultiSelect(boolean var1);

    public boolean isMultiCheck();

    public void setMultiCheck(boolean var1);

    public boolean isEnabled();

    public void setEnabled(boolean var1);

    public boolean isAutoDiscardOnDelete();

    public void setAutoDiscardOnDelete(boolean var1);

    public String getDefaultIconId();

    public void setDefaultIconId(String var1);

    public void requestFocus();

    public void requestFocusInCell(IColumn<?> var1, ITableRow var2);

    public void addTableListener(TableListener var1);

    public void removeTableListener(TableListener var1);

    public void addUITableListener(TableListener var1);

    public IEventHistory<TableEvent> getEventHistory();

    public void setTableChanging(boolean var1);

    public boolean isTableChanging();

    public boolean isTableInitialized();

    public void setRowState(ITableRow var1, int var2) throws ProcessingException;

    public void setRowState(Collection<? extends ITableRow> var1, int var2) throws ProcessingException;

    public void setAllRowState(int var1) throws ProcessingException;

    public void updateRow(ITableRow var1);

    public void updateRows(Collection<? extends ITableRow> var1);

    public void updateAllRows();

    public void replaceRows(List<? extends ITableRow> var1) throws ProcessingException;

    public void replaceRowsByArray(Object var1) throws ProcessingException;

    public void replaceRowsByMatrix(Object var1) throws ProcessingException;

    public int getSelectedRowCount();

    public ITableRow getSelectedRow();

    public List<ITableRow> getSelectedRows();

    public boolean isSelectedRow(ITableRow var1);

    public void selectRow(int var1);

    public void selectRow(ITableRow var1);

    public void selectRow(ITableRow var1, boolean var2);

    public void selectRows(List<? extends ITableRow> var1);

    public void selectRows(List<? extends ITableRow> var1, boolean var2);

    public void selectFirstRow();

    public void selectPreviousRow();

    public void selectNextRow();

    public void selectLastRow();

    public void selectAllRows();

    public void selectAllEnabledRows();

    public void deselectRow(ITableRow var1);

    public void deselectRows(List<? extends ITableRow> var1);

    public void deselectAllRows();

    public void deselectAllEnabledRows();

    public void setCheckableColumn(IBooleanColumn var1);

    public IBooleanColumn getCheckableColumn();

    public Collection<ITableRow> getCheckedRows();

    public void checkRow(int var1, boolean var2) throws ProcessingException;

    public void checkRow(ITableRow var1, boolean var2) throws ProcessingException;

    public void checkRows(Collection<? extends ITableRow> var1, boolean var2) throws ProcessingException;

    public void checkAllRows() throws ProcessingException;

    public void uncheckAllRows() throws ProcessingException;

    public IColumn<?> getContextColumn();

    public void setContextColumn(IColumn<?> var1);

    public ITableRow addRow(ITableRow var1) throws ProcessingException;

    public ITableRow addRow(ITableRow var1, boolean var2) throws ProcessingException;

    public List<ITableRow> addRows(List<? extends ITableRow> var1) throws ProcessingException;

    public List<ITableRow> addRows(List<? extends ITableRow> var1, boolean var2) throws ProcessingException;

    public List<ITableRow> addRows(List<? extends ITableRow> var1, boolean var2, int[] var3) throws ProcessingException;

    public ITableRow addRowByArray(Object var1) throws ProcessingException;

    public List<ITableRow> addRowsByArray(Object var1, int var2) throws ProcessingException;

    public List<ITableRow> addRowsByMatrix(Object var1) throws ProcessingException;

    public List<ITableRow> addRowsByMatrix(Object var1, int var2) throws ProcessingException;

    public List<ITableRow> addRowsByArray(Object var1) throws ProcessingException;

    public void moveRow(int var1, int var2);

    public void moveRowBefore(ITableRow var1, ITableRow var2);

    public void moveRowAfter(ITableRow var1, ITableRow var2);

    public void deleteRow(int var1);

    public void deleteRows(int[] var1);

    public void deleteRow(ITableRow var1);

    public void deleteAllRows();

    public void deleteRows(Collection<? extends ITableRow> var1);

    public void discardRow(int var1);

    public void discardRows(int[] var1);

    public void discardRow(ITableRow var1);

    public void discardAllRows();

    public void discardRows(Collection<? extends ITableRow> var1);

    public void discardAllDeletedRows();

    public void discardDeletedRow(ITableRow var1);

    public void discardDeletedRows(Collection<? extends ITableRow> var1);

    public ITableRow resolveRow(ITableRow var1);

    public List<ITableRow> resolveRows(Collection<? extends ITableRow> var1);

    public void tablePopulated();

    public void sort();

    public void sort(List<? extends ITableRow> var1);

    public boolean isSortEnabled();

    public void setSortEnabled(boolean var1);

    public ITableColumnFilterManager getColumnFilterManager();

    public void setColumnFilterManager(ITableColumnFilterManager var1);

    public ITableCustomizer getTableCustomizer();

    public void setTableCustomizer(ITableCustomizer var1);

    public ITypeWithClassId getContainer();

    public void resetColumnConfiguration();

    public void resetColumnVisibilities();

    public void resetColumnSortOrder();

    public void resetColumnWidths();

    public void resetColumnOrder();

    public void resetDisplayableColumns();

    public void resetColumns(boolean var1, boolean var2, boolean var3, boolean var4);

    public void decorateRow(ITableRow var1);

    public void decorateCell(ITableRow var1, IColumn<?> var2);

    public ITableUIFacade getUIFacade();

    public void exportToTableBeanData(AbstractTableFieldBeanData var1) throws ProcessingException;

    public void importFromTableBeanData(AbstractTableFieldBeanData var1) throws ProcessingException;

    public ITableRowDataMapper createTableRowDataMapper(Class<? extends AbstractTableRowData> var1) throws ProcessingException;

    public void setMenus(List<? extends IMenu> var1);

    public void addMenu(IMenu var1);

    public List<IMenu> getMenus();

    public ITableContextMenu getContextMenu();
}

