/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.wrappedform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.scout.commons.annotations.ClassId;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.commons.xmlparser.SimpleXmlElement;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.IForm;
import org.eclipse.scout.rt.client.ui.form.IFormFieldVisitor;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractFormField;
import org.eclipse.scout.rt.client.ui.form.fields.wrappedform.IWrappedFormField;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.service.SERVICES;

@ClassId(value="535cfd11-39cf-4804-beef-2bc1bc3d34cc")
public abstract class AbstractWrappedFormField<T extends IForm>
extends AbstractFormField
implements IWrappedFormField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractWrappedFormField.class);
    private T m_innerForm;
    private P_InnerFormPropertyChangeListener m_innerFormPropertyListener;
    private P_InnerFormSubtreePropertyChangeListener m_innerFormSubtreePropertyListener;

    public AbstractWrappedFormField() {
        this(true);
    }

    public AbstractWrappedFormField(boolean callInitializer) {
        super(callInitializer);
    }

    @Override
    protected boolean getConfiguredLabelVisible() {
        return false;
    }

    @ConfigProperty(value="FORM")
    @Order(value=200.0)
    protected Class<? extends IForm> getConfiguredInnerForm() {
        return null;
    }

    @Override
    protected double getConfiguredGridWeightY() {
        return 1.0;
    }

    @Override
    protected boolean getConfiguredGridUseUiHeight() {
        return true;
    }

    @Override
    protected void execInitField() throws ProcessingException {
        T f = this.getInnerForm();
        if (f != null && !f.isFormOpen() && f instanceof ISearchForm) {
            ((ISearchForm)f).startSearch();
        }
    }

    @Override
    protected boolean execIsSaveNeeded() throws ProcessingException {
        return this.getInnerForm() != null && this.getInnerForm().isSaveNeeded();
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.m_innerFormPropertyListener = new P_InnerFormPropertyChangeListener();
        this.m_innerFormSubtreePropertyListener = new P_InnerFormSubtreePropertyChangeListener();
        if (this.getConfiguredInnerForm() != null) {
            try {
                this.setInnerForm(this.getConfiguredInnerForm().newInstance());
            }
            catch (Exception e) {
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(new ProcessingException("error creating instance of class '" + this.getConfiguredInnerForm().getName() + "'.", (Throwable)e));
            }
        }
    }

    @Override
    public void setEnabledGranted(boolean b) {
        super.setEnabledGranted(b);
        if (this.getInnerForm() != null) {
            this.getInnerForm().setEnabledGranted(b);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        if (this.getInnerForm() != null) {
            this.getInnerForm().setAllEnabled(b);
        }
    }

    @Override
    public final T getInnerForm() {
        return this.m_innerForm;
    }

    @Override
    public void setInnerForm(T form) {
        if (this.m_innerForm == form) {
            return;
        }
        if (this.m_innerForm != null) {
            this.fireSubtreePropertyChange(new PropertyChangeEvent(this.m_innerForm.getRootGroupBox(), "parentField", null, null));
            this.m_innerForm.removePropertyChangeListener((PropertyChangeListener)this.m_innerFormPropertyListener);
            this.m_innerForm.getRootGroupBox().removeSubtreePropertyChangeListener(this.m_innerFormSubtreePropertyListener);
            this.m_innerForm.setWrapperFieldInternal(null);
            this.m_innerForm = null;
        }
        this.m_innerForm = form;
        if (this.m_innerForm != null) {
            if (!this.m_innerForm.isFormOpen()) {
                this.m_innerForm.setModal(false);
                this.m_innerForm.setAutoAddRemoveOnDesktop(false);
            }
            this.m_innerForm.setWrapperFieldInternal(this);
            this.m_innerForm.getRootGroupBox().setBorderVisible(false);
            this.m_innerForm.getRootGroupBox().updateKeyStrokes();
            this.m_innerForm.addPropertyChangeListener((PropertyChangeListener)this.m_innerFormPropertyListener);
            this.m_innerForm.getRootGroupBox().addSubtreePropertyChangeListener(this.m_innerFormSubtreePropertyListener);
        }
        boolean changed = this.propertySupport.setProperty("innerForm", this.m_innerForm);
        this.calculateVisibleInternal();
        if (this.m_innerForm != null) {
            this.fireSubtreePropertyChange(new PropertyChangeEvent(this.m_innerForm.getRootGroupBox(), "parentField", null, null));
        }
        if (changed && this.getForm() != null) {
            this.getForm().structureChanged(this);
        }
    }

    @Override
    public boolean visitFields(IFormFieldVisitor visitor, int startLevel) {
        if (!visitor.visitField(this, startLevel, 0)) {
            return false;
        }
        if (this.getInnerForm() != null) {
            return this.getInnerForm().getRootGroupBox().visitFields(visitor, startLevel);
        }
        return true;
    }

    @Override
    public void loadXML(SimpleXmlElement x) throws ProcessingException {
        super.loadXML(x);
        if (this.getInnerForm() != null) {
            this.getInnerForm().loadXML(x);
        }
    }

    @Override
    public void storeXML(SimpleXmlElement x) throws ProcessingException {
        super.storeXML(x);
        if (this.getInnerForm() != null) {
            this.getInnerForm().storeXML(x);
        }
    }

    protected void handleFieldVisibilityChanged() {
        this.calculateVisibleInternal();
    }

    private class P_InnerFormPropertyChangeListener
    implements PropertyChangeListener {
        private P_InnerFormPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("visible")) {
                AbstractWrappedFormField.this.handleFieldVisibilityChanged();
            } else if (e.getPropertyName().equals("saveNeeded")) {
                AbstractWrappedFormField.this.checkSaveNeeded();
            }
        }
    }

    private class P_InnerFormSubtreePropertyChangeListener
    implements PropertyChangeListener {
        private P_InnerFormSubtreePropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            AbstractWrappedFormField.this.fireSubtreePropertyChange(e);
        }
    }
}

