/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.jdbc.internal.legacy;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.holders.NVPair;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.services.common.jdbc.style.ISqlStyle;

public class LegacyStatementBuilder {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(LegacyStatementBuilder.class);
    private ISqlStyle m_sqlStyle;
    private Map<String, Object> m_bindMap;
    private long m_bindSeqNo = 0L;
    private StringBuffer m_where;

    public LegacyStatementBuilder(ISqlStyle sqlStyle) {
        this.m_sqlStyle = sqlStyle;
        this.m_bindMap = new HashMap<String, Object>();
    }

    public String resolveComposerAttribute(int op, String attribute, String bindName, Object value) {
        return this.createComposerAttributeOpPattern(op, attribute, bindName, value);
    }

    public Map<String, Object> getBindMap() {
        return this.m_bindMap;
    }

    public ISqlStyle getSqlStyle() {
        return this.m_sqlStyle;
    }

    public void addBind(String name, Object value) {
        if (name != null) {
            this.getBindMap().put(name, value);
        }
    }

    public void addWhereToken(String sql) {
        if (sql != null) {
            this.m_where.append(" AND ");
            this.addWhere(sql, new NVPair[0]);
        }
    }

    public void addWhereToken(String sql, Object valueForS) {
        if (sql != null) {
            String bindName = this.localizeBindName("S", "__");
            sql = this.localizeStatement(sql, "S", bindName);
            this.m_where.append(" AND ");
            this.addWhere(sql, new NVPair(bindName, valueForS));
        }
    }

    public void addWhere(String sql, NVPair ... customBinds) {
        if (sql != null) {
            this.m_where.append(sql);
            NVPair[] nVPairArray = customBinds;
            int n = customBinds.length;
            int n2 = 0;
            while (n2 < n) {
                NVPair p = nVPairArray[n2];
                this.addBind(p.getName(), p.getValue());
                ++n2;
            }
        }
    }

    public String getWhereConstraints() {
        return this.m_where.toString();
    }

    protected long getNextBindSeqNo() {
        return this.m_bindSeqNo++;
    }

    protected String localizeBindName(String bindName, String prefix) {
        if (bindName != null) {
            String locName = String.valueOf(prefix) + bindName + this.getNextBindSeqNo();
            return locName;
        }
        return null;
    }

    protected String localizeStatement(String stm, String oldBindName, String newBindName) {
        stm = stm.replaceAll("#" + oldBindName + "#", "#" + newBindName + "#");
        stm = stm.replaceAll("\\&" + oldBindName + "\\&", "&" + newBindName + "&");
        stm = stm.replaceAll(":" + oldBindName + "([^A-Za-z0-9_])", ":" + newBindName + "$1");
        stm = stm.replaceAll(":" + oldBindName + "$", ":" + newBindName);
        return stm;
    }

    protected String createComposerAttributeOpPattern(int op, String attribute, String bindName, Object value) {
        switch (op) {
            case 27: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createNEQ(attribute, bindName);
            }
            case 26: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createLT(attribute, bindName);
            }
            case 25: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createLE(attribute, bindName);
            }
            case 20: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createEQ(attribute, bindName);
            }
            case 23: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createGT(attribute, bindName);
            }
            case 22: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createGE(attribute, bindName);
            }
            case 2: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInDays(attribute, bindName);
            }
            case 3: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInGEDays(attribute, bindName);
            }
            case 4: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInGEMonths(attribute, bindName);
            }
            case 5: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInLEDays(attribute, bindName);
            }
            case 6: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInLEMonths(attribute, bindName);
            }
            case 7: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInLastDays(attribute, bindName);
            }
            case 8: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInLastMonths(attribute, bindName);
            }
            case 9: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInMonths(attribute, bindName);
            }
            case 10: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInNextDays(attribute, bindName);
            }
            case 11: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateIsInNextMonths(attribute, bindName);
            }
            case 12: {
                return this.m_sqlStyle.createDateIsNotToday(attribute);
            }
            case 13: {
                return this.m_sqlStyle.createDateIsToday(attribute);
            }
            case 14: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateTimeIsInGEHours(attribute, bindName);
            }
            case 15: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateTimeIsInGEMinutes(attribute, bindName);
            }
            case 16: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateTimeIsInLEHours(attribute, bindName);
            }
            case 17: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createDateTimeIsInLEMinutes(attribute, bindName);
            }
            case 18: {
                return this.m_sqlStyle.createDateTimeIsNotNow(attribute);
            }
            case 19: {
                return this.m_sqlStyle.createDateTimeIsNow(attribute);
            }
            case 21: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createEndsWith(attribute, bindName);
            }
            case 29: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createNotEndsWith(attribute, bindName);
            }
            case 24: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createIn(attribute, bindName);
            }
            case 1: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createContains(attribute, bindName);
            }
            case 46: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createLike(attribute, bindName);
            }
            case 30: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createNotIn(attribute, bindName);
            }
            case 28: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createNotContains(attribute, bindName);
            }
            case 31: {
                return this.m_sqlStyle.createNotNull(attribute);
            }
            case 34: {
                return this.m_sqlStyle.createNumberNotNull(attribute);
            }
            case 33: {
                return this.m_sqlStyle.createNull(attribute);
            }
            case 35: {
                return this.m_sqlStyle.createNumberNull(attribute);
            }
            case 36: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createStartsWith(attribute, bindName);
            }
            case 32: {
                this.getBindMap().put(bindName, this.m_sqlStyle.toLikePattern(value));
                return this.m_sqlStyle.createNotStartsWith(attribute, bindName);
            }
            case 37: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInGEHours(attribute, bindName);
            }
            case 38: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInGEMinutes(attribute, bindName);
            }
            case 39: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInHours(attribute, bindName);
            }
            case 40: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInLEHours(attribute, bindName);
            }
            case 41: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInLEMinutes(attribute, bindName);
            }
            case 42: {
                this.getBindMap().put(bindName, value);
                return this.m_sqlStyle.createTimeIsInMinutes(attribute, bindName);
            }
            case 44: {
                return this.m_sqlStyle.createTimeIsNow(attribute);
            }
            case 43: {
                return this.m_sqlStyle.createTimeIsNotNow(attribute);
            }
        }
        throw new IllegalArgumentException("invalid operator: " + op);
    }
}

