/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.transaction.internal;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerJob;
import org.eclipse.scout.rt.server.transaction.ITransaction;

public class ActiveTransactionRegistry {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(ActiveTransactionRegistry.class);
    private static final String SESSION_STATE_KEY = "activeTransactions";

    private ActiveTransactionRegistry() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionState getSessionState(boolean autoCreate) {
        IServerSession session = ServerJob.getCurrentSession();
        if (session == null) {
            return null;
        }
        IServerSession iServerSession = session;
        synchronized (iServerSession) {
            SessionState state = (SessionState)session.getData(SESSION_STATE_KEY);
            if (state == null && autoCreate) {
                state = new SessionState();
                session.setData(SESSION_STATE_KEY, state);
            }
            return state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ITransaction tx) {
        if (tx == null || tx.getTransactionSequence() == 0L) {
            return;
        }
        SessionState state = ActiveTransactionRegistry.getSessionState(true);
        if (state == null) {
            LOG.error("failed to register transaction due to missing session");
            return;
        }
        Object object = state.m_txMapLock;
        synchronized (object) {
            state.m_txMap.put(tx.getTransactionSequence(), new WeakReference<ITransaction>(tx));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(ITransaction tx) {
        if (tx == null || tx.getTransactionSequence() == 0L) {
            return;
        }
        SessionState state = ActiveTransactionRegistry.getSessionState(false);
        if (state == null) {
            return;
        }
        Object object = state.m_txMapLock;
        synchronized (object) {
            state.m_txMap.remove(tx.getTransactionSequence());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean cancel(long transactionSequence) {
        ITransaction tx;
        if (transactionSequence == 0L) {
            return false;
        }
        SessionState state = ActiveTransactionRegistry.getSessionState(false);
        if (state == null) {
            return false;
        }
        Object object = state.m_txMapLock;
        synchronized (object) {
            block8: {
                WeakReference<ITransaction> ref;
                block7: {
                    ref = state.m_txMap.get(transactionSequence);
                    if (ref != null) break block7;
                    return false;
                }
                tx = (ITransaction)ref.get();
                if (tx != null) break block8;
                return false;
            }
        }
        return tx.cancel();
    }

    private static class SessionState {
        final Object m_txMapLock = new Object();
        final HashMap<Long, WeakReference<ITransaction>> m_txMap = new HashMap();

        private SessionState() {
        }
    }
}

