/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import org.eclipse.scout.commons.CollectionUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;

public class BatchLookupResultCache {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(BatchLookupResultCache.class);
    private static final Object globalCacheableLock = new Object();
    private static final HashMap<Class<? extends ILookupCall>, Boolean> globalCacheable = new HashMap();
    private HashMap<ILookupCall, List<ILookupRow<?>>> m_cache = new HashMap();

    public void reset() {
        this.m_cache.clear();
    }

    public List<ILookupRow<?>> getDataByKey(ILookupCall call) throws ProcessingException {
        if (call == null || call.getKey() == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByKey();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByText(ILookupCall call) throws ProcessingException {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByText();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByAll(ILookupCall call) throws ProcessingException {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByAll();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByRec(ILookupCall call) throws ProcessingException {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByRec();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getCachedResult(ILookupCall call) {
        if (call == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return null;
        }
        List<ILookupRow<?>> list = this.m_cache.get(call);
        if (list == null) {
            return null;
        }
        return CollectionUtility.arrayList(list);
    }

    public void putCachedResult(ILookupCall call, List<ILookupRow<?>> result) {
        if (call == null || result == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return;
        }
        this.m_cache.put(call, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheable(Class<? extends ILookupCall> clazz) {
        if (clazz == null) {
            return false;
        }
        Object object = globalCacheableLock;
        synchronized (object) {
            Boolean b = globalCacheable.get(clazz);
            if (b == null) {
                b = BatchLookupResultCache.verifyLookupCallBeanQuality(clazz);
                globalCacheable.put(clazz, b);
            }
            return b;
        }
    }

    private static boolean verifyLookupCallBeanQuality(Class<? extends ILookupCall> clazz) {
        if (clazz == LocalLookupCall.class) {
            return true;
        }
        if (clazz == LookupCall.class) {
            return true;
        }
        Class<? extends ILookupCall> t = clazz;
        while (t != null && t != LookupCall.class) {
            Field[] fieldArray = t.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.isSynthetic() && !f.isEnumConstant() && (f.getModifiers() & 8) == 0) {
                    try {
                        t.getDeclaredMethod("equals", Object.class);
                    }
                    catch (Throwable ex) {
                        LOG.warn(clazz + " subclasses LookupCall with an additional member field '" + t.getSimpleName() + "." + f.getName() + "' and should therefore override the 'boolean equals(Object obj)' and 'int hashCode()' methods");
                        return false;
                    }
                }
                ++n2;
            }
            t = t.getSuperclass();
        }
        return true;
    }
}

