/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.validate.checks;

import java.util.Set;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.validate.ValidationUtility;
import org.eclipse.scout.rt.shared.validate.checks.IValidateCheck;

public class CodeValueCheck
implements IValidateCheck {
    public static final String ID = "codeValue";
    private ICodeType<?, ?> m_codeType;

    public CodeValueCheck(ICodeType<?, ?> codeType) {
        this.m_codeType = codeType;
    }

    @Override
    public String getCheckId() {
        return ID;
    }

    @Override
    public boolean accept(Object obj) {
        return obj != null;
    }

    @Override
    public void check(Object obj) throws Exception {
        if (obj instanceof Set) {
            ValidationUtility.checkCodeTypeSet(obj, this.m_codeType);
        } else {
            ValidationUtility.checkCodeTypeValue(obj, this.m_codeType);
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.m_codeType.getClass().getSimpleName();
    }
}

