/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.gen;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.smartfield.ISmartField;
import org.eclipse.scout.rt.spec.client.SpecUtility;
import org.eclipse.scout.rt.spec.client.config.IDocConfig;
import org.eclipse.scout.rt.spec.client.gen.DocGenUtility;
import org.eclipse.scout.rt.spec.client.gen.IDocFormFieldVisitor;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.IDocTable;
import org.eclipse.scout.rt.spec.client.out.internal.Section;

public class SmartFieldVisitor
implements IDocFormFieldVisitor {
    private final IDocConfig m_config;
    private final List<IDocSection> m_sections = new ArrayList<IDocSection>();

    public SmartFieldVisitor(IDocConfig config) {
        this.m_config = config;
    }

    public boolean visitField(IFormField field, int level, int fieldIndex) {
        if (field instanceof ISmartField) {
            IDocSection fieldDesc = this.createDocSection((ISmartField)field);
            this.m_sections.add(fieldDesc);
        }
        return true;
    }

    protected IDocSection createDocSection(ISmartField<?> field) {
        String title = this.m_config.getSmartFieldConfig().getTitleExtractor().getText(field);
        IDocTable docTable = DocGenUtility.createDocTable(field, this.m_config.getSmartFieldConfig(), true);
        IDocSection menuSection = DocGenUtility.createDocSection(SpecUtility.expandMenuHierarchy(field.getMenus()), this.m_config.getMenuTableConfig(), false);
        return new Section(title, docTable, menuSection);
    }

    @Override
    public List<IDocSection> getDocSections() {
        return this.m_sections;
    }
}

