/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.spec.client.out.mediawiki;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.spec.client.out.IDocSection;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiImageWriter;
import org.eclipse.scout.rt.spec.client.out.mediawiki.MediawikiTableWriter;

public class MediawikiWriter {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(MediawikiWriter.class);
    private final MediawikiTableWriter m_tableWriter;
    private final MediawikiImageWriter m_imageWriter;
    private final String[] m_images;
    private final IDocSection m_section;
    private final Writer m_wikiWriter;

    public MediawikiWriter(Writer wikiWriter, IDocSection section, String[] images) {
        this.m_tableWriter = new MediawikiTableWriter(wikiWriter);
        this.m_imageWriter = new MediawikiImageWriter(wikiWriter);
        this.m_wikiWriter = wikiWriter;
        this.m_section = section;
        this.m_images = (String[])images.clone();
    }

    public void write(int headingLevel) throws ProcessingException {
        try {
            try {
                LOG.info("writing section " + this.m_section.getTitle());
                this.appendSection(this.m_section, headingLevel, true);
                this.m_wikiWriter.flush();
            }
            catch (IOException e) {
                String errorText = "Unable to write wikimedia file for " + this.m_section.getTitle();
                LOG.error(errorText);
                throw new ProcessingException(errorText, (Throwable)e);
            }
        }
        finally {
            try {
                this.m_wikiWriter.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void appendSection(IDocSection section, int headingLevel, boolean appendImages) throws IOException {
        if (section.isDisplayed()) {
            LOG.info("writing section " + section.getTitle());
            this.appendHeading(section, headingLevel);
            this.appendIntroduction(section);
            this.appendTable(section);
            if (appendImages) {
                this.appendImages();
            }
            if (section.getSubSections() != null) {
                for (IDocSection subSection : section.getSubSections()) {
                    this.appendSection(subSection, headingLevel + 1);
                }
            }
        }
    }

    private void appendSection(IDocSection section, int headingLevel) throws IOException {
        this.appendSection(section, headingLevel, false);
    }

    private void appendImages() throws IOException {
        this.m_imageWriter.appendImages(this.m_images);
    }

    private void appendHeading(IDocSection section, int headingLevel) throws IOException {
        if (section.getTitle() != null) {
            this.m_tableWriter.appendHeading(section.getTitle(), headingLevel);
        }
    }

    private void appendIntroduction(IDocSection section) throws IOException {
        String introduction = section.getIntroduction();
        if (!StringUtility.isNullOrEmpty((String)introduction)) {
            this.m_tableWriter.appendText(introduction);
        }
    }

    private void appendTable(IDocSection section) throws IOException {
        if (section.hasTableCellTexts()) {
            if (section.getTable().isTransposedLayout()) {
                this.m_tableWriter.appendTableTransposed(section.getTable());
            } else {
                this.m_tableWriter.appendTable(section.getTable());
            }
        }
    }
}

