/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.testing.ui.swt;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.beans.IPropertyObserver;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ClientSyncJob;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.testing.commons.OsUtility;
import org.eclipse.scout.rt.testing.shared.TestingUtility;
import org.eclipse.scout.rt.testing.shared.WaitCondition;
import org.eclipse.scout.rt.testing.ui.swt.Activator;
import org.eclipse.scout.rt.ui.swt.basic.ColorUtility;
import org.eclipse.scout.rt.ui.swt.basic.ISwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.basic.SwtScoutComposite;
import org.eclipse.scout.rt.ui.swt.ext.DropDownButton;
import org.eclipse.scout.rt.ui.swt.util.SwtUtility;
import org.eclipse.scout.testing.client.AbstractGuiMock;
import org.eclipse.scout.testing.client.IGuiMock;
import org.eclipse.scout.testing.client.robot.JavaRobot;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class SwtMock
extends AbstractGuiMock {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(SwtMock.class);
    private final JavaRobot m_bot = new JavaRobot();
    private int m_treeNodeToExpandIconGap;

    public SwtMock(IClientSession session) {
        super(session);
    }

    public void initializeMock() {
    }

    public void shutdownMock() {
    }

    public void beforeTest() {
    }

    public void afterTest() {
    }

    public IGuiMock.GuiStrategy getStrategy() {
        return IGuiMock.GuiStrategy.Swt;
    }

    public int getTreeNodeToExpandIconGap() {
        if (this.m_treeNodeToExpandIconGap <= 0) {
            String s = Activator.getDefault().getBundle().getBundleContext().getProperty("IGuiMock.treeNodeToExpandIconGap");
            if (s == null) {
                LOG.warn("Missing config.ini property 'IGuiMock.treeNodeToExpandIconGap'; using default value of 4");
                s = "4";
            }
            this.m_treeNodeToExpandIconGap = Integer.parseInt(s);
        }
        return this.m_treeNodeToExpandIconGap;
    }

    public void setTreeNodeToExpandIconGap(int treeNodeToExpandIconGap) {
        this.m_treeNodeToExpandIconGap = treeNodeToExpandIconGap;
    }

    public void waitForIdle() {
        if (this.getDisplay().getThread() == Thread.currentThread()) {
            return;
        }
        int pass = 0;
        while (pass < 2) {
            this.m_bot.sleep(80);
            this.syncExec(new WaitCondition<Object>(){

                public Object run() throws Throwable {
                    return null;
                }
            });
            ClientSyncJob idleJob = new ClientSyncJob("Check for idle", this.getClientSession()){

                protected void runVoid(IProgressMonitor m) throws Throwable {
                }
            };
            idleJob.setSystem(true);
            final CountDownLatch idleJobScheduledSignal = new CountDownLatch(1);
            JobChangeAdapter listener = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    idleJobScheduledSignal.countDown();
                }
            };
            try {
                idleJob.addJobChangeListener((IJobChangeListener)listener);
                idleJob.schedule();
                try {
                    idleJobScheduledSignal.await();
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException("Interrupted");
                }
            }
            finally {
                idleJob.removeJobChangeListener((IJobChangeListener)listener);
            }
            ++pass;
        }
    }

    public void waitForActiveWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (SwtMock.this.isWindowActive(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public void waitForOpenWindow(final String title) {
        this.waitUntil(new WaitCondition<Object>(){

            public Object run() {
                if (SwtMock.this.isWindowOpen(title)) {
                    return true;
                }
                return null;
            }
        });
        this.waitForIdle();
    }

    public int getSleepDelay() {
        return this.m_bot.getAutoDelay();
    }

    public void setSleepDelay(int sleepDelay) {
        this.m_bot.setAutoDelay(sleepDelay);
    }

    public void sleep() {
        this.sleep(this.getSleepDelay());
    }

    public void sleep(int millis) {
        if (this.getDisplay().getThread() == Thread.currentThread()) {
            return;
        }
        this.m_bot.sleep(millis);
        this.waitForIdle();
    }

    public boolean isWindowActive(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                CTabItem view = SwtMock.this.findWorkbenchView(title);
                if (view != null && view.getParent().getSelection() == view) {
                    return true;
                }
                Shell shell = SwtMock.this.findShell(title);
                if (shell != null && shell == SwtMock.this.getActiveShell()) {
                    return true;
                }
                return false;
            }
        });
    }

    public boolean isWindowOpen(final String title) {
        return this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                CTabItem view = SwtMock.this.findWorkbenchView(title);
                if (view != null) {
                    return true;
                }
                Shell shell = SwtMock.this.findShell(title);
                if (shell != null) {
                    return true;
                }
                return false;
            }
        });
    }

    public void activateWindow(final String title) {
        this.waitForOpenWindow(title);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                CTabItem view = SwtMock.this.findWorkbenchView(title);
                if (view != null) {
                    view.getParent().setSelection(view);
                    return null;
                }
                Shell shell = SwtMock.this.findShell(title);
                if (shell != null) {
                    shell.setActive();
                    return null;
                }
                throw new IllegalStateException("There is no view with title " + title);
            }
        });
        this.waitForIdle();
    }

    public IGuiMock.FieldState getFieldState(IGuiMock.FieldType type, int index) {
        final Control c = this.waitForIndexedField(type, index);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return SwtMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldState(String name) {
        final Control c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                return SwtMock.this.getFieldStateInternal(c);
            }
        });
    }

    public IGuiMock.FieldState getScoutFieldContainerState(String name) {
        final Control c = this.waitForScoutField(name);
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                ISwtScoutComposite swtScoutComposite = SwtScoutComposite.getCompositeOnWidget((Widget)c);
                if (swtScoutComposite == null) {
                    return null;
                }
                return SwtMock.this.getFieldStateInternal((Control)swtScoutComposite.getSwtContainer());
            }
        });
    }

    public List<IGuiMock.FieldState> getFieldStates(final IGuiMock.FieldType type) {
        return this.syncExec(new WaitCondition<List<IGuiMock.FieldState>>(){

            public List<IGuiMock.FieldState> run() throws Throwable {
                ArrayList<IGuiMock.FieldState> list = new ArrayList<IGuiMock.FieldState>();
                for (Control c : SwtUtility.findChildComponents((Widget)SwtMock.this.getActiveShell(), Control.class)) {
                    if (type == null && SwtMock.this.getFieldTypeOf(c) != null) {
                        list.add(SwtMock.this.getFieldStateInternal(c));
                        continue;
                    }
                    if (type == null || SwtMock.this.getFieldTypeOf(c) != type) continue;
                    list.add(SwtMock.this.getFieldStateInternal(c));
                }
                return list;
            }
        });
    }

    public IGuiMock.FieldState getFocusFieldState() {
        return this.syncExec(new WaitCondition<IGuiMock.FieldState>(){

            public IGuiMock.FieldState run() throws Throwable {
                Control c = SwtMock.this.getDisplay().getFocusControl();
                if (c == null) {
                    throw new IllegalStateException("There is no focus owner");
                }
                return SwtMock.this.getFieldStateInternal(c);
            }
        });
    }

    public void clickOnPushButton(String text) {
        final Control c = this.waitForPushButtonWithLabel(text);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.toDisplay(5, 5);
                SwtMock.this.gotoPoint(p.x, p.y);
                SwtMock.this.clickLeft();
                return null;
            }
        });
        this.waitForIdle();
    }

    public void gotoField(IGuiMock.FieldType type, int index) {
        final Control c = this.waitForIndexedField(type, index);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.toDisplay(c.getSize().x / 2, c.getSize().y / 2);
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoScoutField(String name) {
        this.gotoScoutField(name, 0.5, 0.5);
    }

    public void gotoScoutField(String name, final double x, final double y) {
        if (x < 0.0 || x > 1.0) {
            throw new IllegalArgumentException("x should be in [0, 1] range.");
        }
        if (y < 0.0 || y > 1.0) {
            throw new IllegalArgumentException("y should be in [0, 1] range.");
        }
        final Control c = this.waitForScoutField(name);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Point p = c.toDisplay((int)(x * (double)c.getSize().x), (int)(y * (double)c.getSize().y));
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoTable(int tableIndex, final int rowIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                TableItem item = table.getItem(rowIndex);
                Rectangle cellBounds = item.getBounds(columnIndex + 1);
                if (!table.getClientArea().contains(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2)) {
                    throw new IllegalStateException("table cell " + rowIndex + "," + columnIndex + " is not visible on screen");
                }
                Point p = table.toDisplay(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoTableHeader(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                int curIndex = -1;
                int accumulatedWidth = 0;
                Rectangle cellBounds = null;
                int[] nArray = table.getColumnOrder();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    TableColumn col = table.getColumn(i);
                    if (i > 0 && ++curIndex == columnIndex) {
                        cellBounds = new Rectangle(accumulatedWidth, 0, col.getWidth(), table.getHeaderHeight());
                        break;
                    }
                    accumulatedWidth += col.getWidth();
                    ++n2;
                }
                cellBounds.x -= table.getHorizontalBar().getSelection();
                Point p = table.toDisplay(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoTree(int treeIndex, final String nodeText) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                TreeItem item = SwtMock.this.findTreeItemRec(tree.getItems(), nodeText);
                if (item == null) {
                    throw new IllegalStateException("Cannot find tree item '" + nodeText + "'");
                }
                Rectangle cellBounds = item.getBounds(0);
                if (!tree.getClientArea().contains(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2)) {
                    throw new IllegalStateException("tree node " + nodeText + " is not visible on screen");
                }
                Point p = tree.toDisplay(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public void gotoTreeExpandIcon(int treeIndex, final String nodeText) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                TreeItem item = SwtMock.this.findTreeItemRec(tree.getItems(), nodeText);
                if (item == null) {
                    throw new IllegalStateException("Cannot find tree item '" + nodeText + "'");
                }
                Rectangle cellBounds = item.getBounds(0);
                if (!tree.getClientArea().contains(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2)) {
                    throw new IllegalStateException("tree node " + nodeText + " is not visible on screen");
                }
                Point p = tree.toDisplay(cellBounds.x - SwtMock.this.getTreeNodeToExpandIconGap() - 2, cellBounds.y + cellBounds.height / 2);
                SwtMock.this.gotoPoint(p.x, p.y);
                return null;
            }
        });
    }

    public org.eclipse.scout.testing.client.menu.MenuItem getContextMenuItem(String label) {
        final MenuItem uiMenuItem = this.getMenuItem(label);
        return this.syncExec(new WaitCondition<org.eclipse.scout.testing.client.menu.MenuItem>(){

            public org.eclipse.scout.testing.client.menu.MenuItem run() throws Throwable {
                if (uiMenuItem != null) {
                    return new org.eclipse.scout.testing.client.menu.MenuItem(uiMenuItem.getText(), uiMenuItem.isEnabled(), true);
                }
                return null;
            }
        });
    }

    public void contextMenu(final String ... names) {
        final ArrayList indexOfList = new ArrayList();
        final MenuItem mi = this.waitForMenuItem(names[0]);
        this.syncExec(new WaitCondition<Boolean>(){

            public Boolean run() throws Throwable {
                indexOfList.add(SwtMock.this.accessibleMenuIndex(mi));
                MenuItem parentMenuItem = mi;
                int i = 1;
                while (i < names.length) {
                    String label = SwtMock.this.cleanButtonLabel(names[i]);
                    MenuItem subItem = null;
                    MenuItem[] menuItemArray = parentMenuItem.getMenu().getItems();
                    int n = menuItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem item = menuItemArray[n2];
                        if (label.equals(SwtMock.this.cleanButtonLabel(item.getText()))) {
                            subItem = item;
                            break;
                        }
                        ++n2;
                    }
                    if (subItem == null) {
                        throw new IllegalStateException("cannot find submenu " + names[i]);
                    }
                    indexOfList.add(SwtMock.this.accessibleMenuIndex(subItem));
                    parentMenuItem = subItem;
                    ++i;
                }
                return null;
            }
        });
        int i = 0;
        while (i < indexOfList.size()) {
            if (i > 0) {
                this.typeKey(IGuiMock.Key.Right);
            }
            int repeat = (Integer)indexOfList.get(i);
            if (i == 0) {
                ++repeat;
            }
            while (repeat > 0) {
                --repeat;
                this.typeKey(IGuiMock.Key.Down);
            }
            ++i;
        }
        this.typeKey(IGuiMock.Key.Enter);
        this.waitForIdle();
    }

    protected int accessibleMenuIndex(MenuItem mi) {
        Menu m = mi.getParent();
        int index = 0;
        MenuItem[] menuItemArray = m.getItems();
        int n = menuItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItem x = menuItemArray[n2];
            if (x == mi) break;
            if ((x.getStyle() & 2) == 0 && x.isEnabled()) {
                ++index;
            }
            ++n2;
        }
        return index;
    }

    public List<String> getTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                TableItem[] tableItemArray = table.getItems();
                int n = tableItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TableItem row = tableItemArray[n2];
                    list.add(row.getText(columnIndex + 1));
                    ++n2;
                }
                return list;
            }
        });
    }

    public List<String> getTreeNodes(int treeIndex) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<List<String>>(){

            public List<String> run() throws Throwable {
                ArrayList<String> list = new ArrayList<String>();
                SwtMock.this.addTreeItemsRec(tree.getItems(), list);
                return list;
            }
        });
    }

    public Set<String> getSelectedTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                TableItem[] sel = table.getSelection();
                if (sel != null) {
                    TableItem[] tableItemArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TableItem row = tableItemArray[n2];
                        set.add(row.getText(columnIndex + 1));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public Set<String> getSelectedTreeNodes(int treeIndex) {
        final Tree tree = (Tree)this.waitForIndexedField(IGuiMock.FieldType.Tree, treeIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> set = new TreeSet<String>();
                TreeItem[] sel = tree.getSelection();
                if (sel != null) {
                    TreeItem[] treeItemArray = sel;
                    int n = sel.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem row = treeItemArray[n2];
                        set.add(row.getText(0));
                        ++n2;
                    }
                }
                return set;
            }
        });
    }

    public Set<String> getCheckedTableCells(int tableIndex, final int columnIndex) {
        final Table table = (Table)this.waitForIndexedField(IGuiMock.FieldType.Table, tableIndex);
        return this.syncExec(new WaitCondition<Set<String>>(){

            public Set<String> run() throws Throwable {
                TreeSet<String> check = new TreeSet<String>();
                int i = 0;
                while (i < table.getItemCount()) {
                    ITableRow row;
                    TableItem item = table.getItem(i);
                    if (item.getData() instanceof ITableRow && (row = (ITableRow)item.getData()).isChecked()) {
                        check.add(item.getText(columnIndex + 1));
                    }
                    ++i;
                }
                return check;
            }
        });
    }

    public void gotoPoint(int x, int y) {
        this.m_bot.moveTo(x, y);
    }

    public void move(int deltaX, int deltaY) {
        this.m_bot.moveDelta(deltaX, deltaY);
    }

    public void clickLeft() {
        this.m_bot.clickLeft();
        this.waitForIdle();
    }

    public void clickRight() {
        this.m_bot.clickRight();
        this.waitForIdle();
    }

    public void pressLeft() {
        this.m_bot.pressLeft();
    }

    public void releaseLeft() {
        this.m_bot.releaseLeft();
        this.waitForIdle();
    }

    public void drag(int x1, int y1, int x2, int y2) {
        this.gotoPoint(x1, y1);
        this.m_bot.pressLeft();
        this.gotoPoint(x2, y2);
        this.m_bot.releaseLeft();
        this.waitForIdle();
    }

    public void dragWindowRightBorder(IGuiMock.WindowState windowState, int pixelToMoveOnX) {
        int borderSize = OsUtility.isWindows7() ? 5 : 4;
        int xPos = windowState.x + windowState.width + borderSize;
        int yPos = windowState.y + windowState.height / 2;
        this.drag(xPos, yPos, xPos + pixelToMoveOnX, yPos);
    }

    public void typeText(String text) {
        this.m_bot.typeText(text);
        this.waitForIdle();
    }

    public void paste(String text) {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), null);
        this.m_bot.pressKey(IGuiMock.Key.Control);
        this.m_bot.typeText("v");
        this.m_bot.releaseKey(IGuiMock.Key.Control);
    }

    public void pressKey(IGuiMock.Key key) {
        this.m_bot.pressKey(key);
        this.waitForIdle();
    }

    public void releaseKey(IGuiMock.Key key) {
        this.m_bot.releaseKey(key);
        this.waitForIdle();
    }

    public void typeKey(IGuiMock.Key key) {
        this.m_bot.typeKey(key);
        this.waitForIdle();
    }

    public IGuiMock.WindowState getWindowState(final String title) {
        return this.syncExec(new WaitCondition<IGuiMock.WindowState>(){

            public IGuiMock.WindowState run() throws Throwable {
                SwtMock.this.checkActiveShell();
                CTabItem view = SwtMock.this.findWorkbenchView(title);
                if (view != null) {
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    Point p = view.getParent().toDisplay(0, 0);
                    Point s = view.getParent().getSize();
                    state.x = p.x;
                    state.y = p.y;
                    state.width = s.x;
                    state.height = s.y;
                    return state;
                }
                Shell shell = SwtMock.this.findShell(title);
                if (shell != null) {
                    Rectangle r = shell.getBounds();
                    IGuiMock.WindowState state = new IGuiMock.WindowState();
                    state.x = r.x;
                    state.y = r.y;
                    state.width = r.width;
                    state.height = r.height;
                    return state;
                }
                throw new IllegalStateException("Window " + title + " not found");
            }
        });
    }

    public String getClipboardText() {
        this.waitForIdle();
        return this.syncExec(new WaitCondition<String>(){

            public String run() throws Throwable {
                Clipboard b = new Clipboard(SwtMock.this.getDisplay());
                return (String)b.getContents((Transfer)TextTransfer.getInstance());
            }
        });
    }

    public void setClipboardText(final String value) {
        this.waitForIdle();
        this.syncExec(new WaitCondition<Object>(){

            public Object run() throws Throwable {
                Clipboard b = new Clipboard(SwtMock.this.getDisplay());
                if (StringUtility.isNullOrEmpty((String)value)) {
                    b.clearContents();
                } else {
                    b.setContents(new Object[]{value}, new Transfer[]{TextTransfer.getInstance()});
                }
                return null;
            }
        });
    }

    public Object internal0(Object o) {
        return this.syncExec(new WaitCondition<String>(){

            public String run() throws Throwable {
                return null;
            }
        });
    }

    protected void checkActiveShell() {
        if (this.getActiveShell() == null) {
            throw new IllegalStateException("There is no active shell");
        }
    }

    protected IGuiMock.FieldState getFieldStateInternal(Control c) {
        IGuiMock.FieldState state = new IGuiMock.FieldState();
        state.type = this.getFieldTypeOf(c);
        IPropertyObserver scoutObject = SwtScoutComposite.getScoutModelOnWidget((Widget)c);
        state.scoutName = scoutObject != null ? scoutObject.getClass().getName() : null;
        state.focus = c == this.getDisplay().getFocusControl();
        Point p = c.toDisplay(0, 0);
        state.x = p.x;
        state.y = p.y;
        state.width = c.getBounds().width;
        state.height = c.getBounds().height;
        state.foregroundColor = ColorUtility.createStringFromColor((Color)c.getForeground());
        state.backgroundColor = ColorUtility.createStringFromColor((Color)c.getBackground());
        if (c instanceof Label) {
            state.text = ((Label)c).getText();
        }
        if (c instanceof Text) {
            state.text = ((Text)c).getText();
        }
        if (c instanceof StyledText) {
            state.text = ((StyledText)c).getText();
        }
        if (c instanceof Button) {
            Button button = (Button)c;
            state.text = button.getText();
            state.selected = button.getSelection();
        }
        state.visible = c.isVisible();
        state.widget = c;
        return state;
    }

    protected IGuiMock.FieldType getFieldTypeOf(Control c) {
        if (c.isDisposed()) {
            return null;
        }
        if (!c.isVisible()) {
            return null;
        }
        if (c instanceof Label) {
            return IGuiMock.FieldType.Label;
        }
        if (c instanceof Text) {
            return IGuiMock.FieldType.Text;
        }
        if (c instanceof StyledText) {
            return IGuiMock.FieldType.Text;
        }
        if (c instanceof Table) {
            return IGuiMock.FieldType.Table;
        }
        if (c instanceof Tree) {
            return IGuiMock.FieldType.Tree;
        }
        if (c instanceof DropDownButton) {
            return IGuiMock.FieldType.DropdownButton;
        }
        if (c instanceof Button) {
            int style = c.getStyle();
            if ((style & 0x20) != 0) {
                return IGuiMock.FieldType.Checkbox;
            }
            if ((style & 0x10) != 0) {
                return IGuiMock.FieldType.RadioButton;
            }
            if (c.getParent() instanceof Scrollable) {
                return IGuiMock.FieldType.ScrollButton;
            }
            return IGuiMock.FieldType.PushButton;
        }
        return null;
    }

    protected String getScoutNameOf(Control c) {
        IPropertyObserver scoutObject = SwtScoutComposite.getScoutModelOnWidget((Widget)c);
        if (scoutObject != null) {
            return scoutObject.getClass().getName();
        }
        return null;
    }

    protected Display getDisplay() {
        if (PlatformUI.isWorkbenchRunning()) {
            return PlatformUI.getWorkbench().getDisplay();
        }
        return null;
    }

    protected Shell getActiveShell() {
        return this.getDisplay().getActiveShell();
    }

    protected String cleanButtonLabel(String s) {
        return StringUtility.removeMnemonic((String)s);
    }

    protected TreeItem findTreeItemRec(TreeItem[] items, String nodeText) {
        if (items == null) {
            return null;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (nodeText.equals(item.getText())) {
                return item;
            }
            TreeItem found = this.findTreeItemRec(item.getItems(), nodeText);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    protected void addTreeItemsRec(TreeItem[] items, List<String> list) {
        if (items == null) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            list.add(item.getText(0));
            if (item.getExpanded()) {
                this.addTreeItemsRec(item.getItems(), list);
            }
            ++n2;
        }
    }

    protected List<Composite> enumerateParentContainers() {
        return this.syncExec(new WaitCondition<ArrayList<Composite>>(){

            public ArrayList<Composite> run() throws Throwable {
                ArrayList<Composite> list = new ArrayList<Composite>();
                Shell[] shellArray = SwtMock.this.getDisplay().getShells();
                int n = shellArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell.isVisible()) {
                        list.add((Composite)shell);
                    }
                    ++n2;
                }
                return list;
            }
        });
    }

    protected Shell findShell(String title) {
        Shell[] shellArray = this.getDisplay().getShells();
        int n = shellArray.length;
        int n2 = 0;
        while (n2 < n) {
            Shell shell = shellArray[n2];
            if (title.equals(shell.getText())) {
                return shell;
            }
            ++n2;
        }
        return null;
    }

    protected CTabItem findWorkbenchView(String title) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null) {
            for (CTabFolder f : SwtUtility.findChildComponents((Widget)shell, CTabFolder.class)) {
                if (f.getItemCount() <= 0) continue;
                CTabItem[] cTabItemArray = f.getItems();
                int n = cTabItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    CTabItem item = cTabItemArray[n2];
                    if (item.isShowing() && title.equals(this.cleanCTabItemTitle(item.getText()))) {
                        return item;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    protected String cleanCTabItemTitle(String title) {
        String result = StringUtility.removeMnemonic((String)title);
        return StringUtility.removePrefixes((String)result, (String[])new String[]{"*"}).trim();
    }

    protected Control waitForPushButtonWithLabel(final String label) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return SwtMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        Shell[] shellArray = SwtMock.this.getDisplay().getShells();
                        int n = shellArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell shell;
                            Shell parent = shell = shellArray[n2];
                            for (Control o : SwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                if (!(o instanceof Button) || !SwtMock.this.cleanButtonLabel(label).equals(SwtMock.this.cleanButtonLabel(((Button)o).getText()))) continue;
                                return o;
                            }
                            ++n2;
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected Control waitForScoutField(final String name) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return SwtMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        Control lastSecondaryCandidate = null;
                        for (Composite parent : SwtMock.this.enumerateParentContainers()) {
                            for (Control c : SwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                String s = SwtMock.this.getScoutNameOf(c);
                                if (s == null || !("." + s).endsWith("." + name)) continue;
                                lastSecondaryCandidate = c;
                                if (SwtMock.this.getFieldTypeOf(c) == null) continue;
                                return c;
                            }
                        }
                        return lastSecondaryCandidate;
                    }
                });
            }
        });
    }

    protected Control waitForIndexedField(final IGuiMock.FieldType type, final int fieldIndex) {
        return this.waitUntil(new WaitCondition<Control>(){

            public Control run() {
                return SwtMock.this.syncExec(new WaitCondition<Control>(){

                    public Control run() throws Throwable {
                        List<Composite> parents = SwtMock.this.enumerateParentContainers();
                        for (Composite parent : parents) {
                            int index = 0;
                            for (Control c : SwtUtility.findChildComponents((Widget)parent, Control.class)) {
                                if (SwtMock.this.getFieldTypeOf(c) != type) continue;
                                if (index == fieldIndex) {
                                    return c;
                                }
                                ++index;
                            }
                        }
                        return null;
                    }
                });
            }
        });
    }

    protected MenuItem waitForMenuItem(final String name) {
        return this.waitUntil(new WaitCondition<MenuItem>(){

            public MenuItem run() {
                return SwtMock.this.getMenuItem(name);
            }
        });
    }

    protected MenuItem getMenuItem(final String name) {
        return this.syncExec(new WaitCondition<MenuItem>(){

            public MenuItem run() throws Throwable {
                MenuItem item;
                int n;
                int n2;
                MenuItem[] menuItemArray;
                Menu m;
                Menu m2;
                String label = SwtMock.this.cleanButtonLabel(name);
                Control focusControl = SwtMock.this.getDisplay().getFocusControl();
                if (focusControl != null && (m2 = focusControl.getMenu()) != null) {
                    MenuItem[] menuItemArray2 = m2.getItems();
                    int n3 = menuItemArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MenuItem item2 = menuItemArray2[n4];
                        if (label.equals(SwtMock.this.cleanButtonLabel(item2.getText()))) {
                            return item2;
                        }
                        ++n4;
                    }
                }
                for (Composite parent : SwtMock.this.enumerateParentContainers()) {
                    for (Control c : SwtUtility.findChildComponents((Widget)parent, Control.class)) {
                        m = c.getMenu();
                        if (m == null) continue;
                        menuItemArray = m.getItems();
                        n2 = menuItemArray.length;
                        n = 0;
                        while (n < n2) {
                            item = menuItemArray[n];
                            if (label.equals(SwtMock.this.cleanButtonLabel(item.getText()))) {
                                return item;
                            }
                            ++n;
                        }
                    }
                }
                Shell[] shellArray = SwtMock.this.getDisplay().getShells();
                int n5 = shellArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Shell shell = shellArray[n6];
                    m = shell.getMenuBar();
                    if (m != null) {
                        menuItemArray = m.getItems();
                        n2 = menuItemArray.length;
                        n = 0;
                        while (n < n2) {
                            item = menuItemArray[n];
                            if (label.equals(SwtMock.this.cleanButtonLabel(item.getText()))) {
                                return item;
                            }
                            ++n;
                        }
                    }
                    ++n6;
                }
                return null;
            }
        });
    }

    protected <T> T syncExec(final WaitCondition<T> r) {
        if (this.getDisplay().getThread() != Thread.currentThread()) {
            final AtomicReference ret = new AtomicReference();
            final AtomicReference ex = new AtomicReference();
            try {
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ret.set(SwtMock.this.syncExec(r));
                        }
                        catch (Throwable t) {
                            ex.set(t);
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Throwable)ex.get();
                }
                return (T)ret.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        try {
            return (T)r.run();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    protected <T> T waitUntil(WaitCondition<T> w) {
        try {
            Object object = TestingUtility.waitUntil((long)10000L, w);
            return (T)object;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        finally {
            this.waitForIdle();
        }
    }

    public void clickLeftOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        final Control c = (Control)fieldState.widget;
        if (c != null) {
            try {
                final AtomicReference buttonLocation = new AtomicReference();
                final AtomicReference ex = new AtomicReference();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Button button = SwtMock.this.getNextButton(c);
                            Point p = button.toDisplay(5, 5);
                            buttonLocation.set(p);
                        }
                        catch (Throwable t) {
                            ex.set(t);
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Throwable)ex.get();
                }
                Point p = (Point)buttonLocation.get();
                this.gotoPoint(p.x, p.y);
                this.clickLeft();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else {
            this.gotoPoint(fieldState.x + fieldState.width + 10, fieldState.y + 10);
            this.clickLeft();
        }
    }

    public void clickRightOnSmartFieldMagnifier(IGuiMock.FieldState fieldState) {
        final Control c = (Control)fieldState.widget;
        if (c != null) {
            try {
                final AtomicReference buttonLocation = new AtomicReference();
                final AtomicReference ex = new AtomicReference();
                this.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Button button = SwtMock.this.getNextButton(c);
                            Point p = button.toDisplay(5, 5);
                            buttonLocation.set(p);
                        }
                        catch (Throwable t) {
                            ex.set(t);
                        }
                    }
                });
                if (ex.get() != null) {
                    throw (Throwable)ex.get();
                }
                Point p = (Point)buttonLocation.get();
                this.gotoPoint(p.x, p.y);
                this.clickRight();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        } else {
            this.gotoPoint(fieldState.x + fieldState.width + 10, fieldState.y + 10);
            this.clickRight();
        }
    }

    private Button getNextButton(Control c) {
        if (c instanceof Button) {
            return (Button)c;
        }
        if (c instanceof Composite) {
            Button b = this.findButtonInComposite((Composite)c);
            if (b != null) {
                return b;
            }
            if (c.getParent() != null) {
                return this.getNextButton((Control)c.getParent());
            }
        }
        return null;
    }

    private Button findButtonInComposite(Composite comp) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b;
            Control c = controlArray[n2];
            if (c instanceof Button) {
                return (Button)c;
            }
            if (c instanceof Composite && (b = this.findButtonInComposite((Composite)c)) != null) {
                return b;
            }
            ++n2;
        }
        return null;
    }
}

