/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.svg.calendar.builder;

import java.util.Calendar;
import org.eclipse.scout.rt.ui.svg.calendar.builder.AbstractCalendarDocumentBuilder;
import org.eclipse.scout.rt.ui.svg.calendar.comp.IComponentElementFactory;
import org.eclipse.scout.rt.ui.svg.calendar.comp.LinearFillComponentElementFactory;

public class CalendarMonthBuilder
extends AbstractCalendarDocumentBuilder {
    public CalendarMonthBuilder() {
        super("resources/MonthCalendar.svg");
    }

    @Override
    protected int getNumWeekdays() {
        return 7;
    }

    @Override
    protected int getNumWeeks() {
        return 6;
    }

    @Override
    protected IComponentElementFactory getComponentElementFactory() {
        return new LinearFillComponentElementFactory();
    }

    @Override
    protected int getDisplayMode() {
        return 3;
    }

    @Override
    protected String getDayTitle(Calendar cal) {
        return "" + cal.get(5);
    }

    @Override
    protected boolean hasTimeLine() {
        return false;
    }

    @Override
    protected void truncateToRange(Calendar cal) {
        cal.set(5, 1);
        cal.add(5, -this.getNumOfDaysInWeekBefore(cal));
    }

    @Override
    protected int getSmallNextField() {
        return 2;
    }

    @Override
    protected String getRangeTitle(Calendar cal) {
        return String.valueOf(this.getMonthLabel(cal.get(2))) + " " + cal.get(1);
    }

    @Override
    protected int getBigNextField() {
        return 1;
    }

    @Override
    protected void resizeDayBoxes(double gridHeight) {
    }

    @Override
    protected double getGridTop() {
        return 0.0;
    }
}

