/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.action;

import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JMenu;
import org.eclipse.scout.rt.client.ui.action.IActionFilter;
import org.eclipse.scout.rt.client.ui.action.tree.IActionNode;
import org.eclipse.scout.rt.ui.swing.action.ISwingScoutAction;
import org.eclipse.scout.rt.ui.swing.action.SwingScoutAction;
import org.eclipse.scout.rt.ui.swing.basic.SwingScoutComposite;

public class SwingScoutMenu<T extends IActionNode<?>>
extends SwingScoutComposite<T>
implements ISwingScoutAction<T> {
    private SwingScoutAction<T> m_actionComposite;
    private IActionFilter m_filter;

    public SwingScoutMenu(IActionFilter filter) {
        this.m_filter = filter;
    }

    @Override
    protected void initializeSwing() {
        super.initializeSwing();
        this.m_actionComposite = new SwingScoutAction();
        this.m_actionComposite.createField((IActionNode)this.getScoutObject(), this.getSwingEnvironment());
        JMenu swingMenu = new JMenu(this.m_actionComposite.getSwingAction());
        this.setSwingField(swingMenu);
        swingMenu.setVisible(((IActionNode)this.getScoutObject()).isVisible());
        this.m_actionComposite.getSwingAction().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                JMenu c;
                if ("visible".equals(e.getPropertyName()) && (c = SwingScoutMenu.this.getSwingField()) != null) {
                    c.setVisible((Boolean)e.getNewValue());
                }
            }
        });
    }

    @Override
    public Action getSwingAction() {
        return this.m_actionComposite.getSwingAction();
    }

    @Override
    protected void handleSwingRemoveNotify() {
        super.handleSwingRemoveNotify();
        this.m_actionComposite.disposeAction();
    }

    @Override
    public JMenu getSwingField() {
        return (JMenu)super.getSwingField();
    }

    public SwingScoutAction getActionComposite() {
        return this.m_actionComposite;
    }

    protected void updateChildActionsFromScout() {
        JMenu c = this.getSwingField();
        if (c != null) {
            ((Container)c).removeAll();
            this.getSwingEnvironment().appendActions(c, ((IActionNode)this.getScoutObject()).getChildActions(), this.m_filter);
        }
    }

    @Override
    protected void handleScoutPropertyChange(String name, Object newValue) {
        super.handleScoutPropertyChange(name, newValue);
        if ("childActions".equals(name)) {
            this.updateChildActionsFromScout();
        }
    }
}

