/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.swing.basic.activitymap;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.UIManager;
import org.eclipse.scout.rt.client.ui.basic.activitymap.ActivityCell;
import org.eclipse.scout.rt.ui.swing.ext.LookAndFeelUtility;
import org.eclipse.scout.rt.ui.swing.ext.activitymap.DefaultActivityComponent;

public class SwingActivityComponent
extends DefaultActivityComponent {
    private static final long serialVersionUID = 1L;
    private ActivityCell m_cell;

    public SwingActivityComponent(ActivityCell cell, int rowIndex) {
        super(rowIndex);
        this.m_cell = cell;
        this.setText(cell.getText());
        this.setToolTipText(cell.getTooltipText());
    }

    public ActivityCell getScoutActivityCell() {
        return this.m_cell;
    }

    @Override
    protected void paintComponent(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        Shape oldShape = g.getClip();
        try {
            if (this.m_cell.getMajorColor() != null) {
                float f = this.m_cell.getMajorValue();
                if (f < 0.0f) {
                    f = 0.0f;
                }
                if (f > 1.0f) {
                    f = 1.0f;
                }
                int dy = (int)(f * (float)(h - 2 - 2));
                g.setColor(Color.white);
                g.fillRect(2, 2, w - 2 - 2, h - 2 - 2);
                g.setColor(Color.decode("0x" + this.m_cell.getMajorColor()));
                if (dy > 0) {
                    g.fillRect(2, h - 2 - dy + 1, w - 2 - 2 + 1, dy);
                }
                g.drawRect(2, 2, w - 2 - 2, h - 2 - 2);
                if (this.m_cell.getMinorColor() != null) {
                    f = this.m_cell.getMinorValue();
                    if (f < 0.0f) {
                        f = 0.0f;
                    }
                    if (f > 1.0f) {
                        f = 1.0f;
                    }
                    dy = (int)(f * (float)(h - 2 - 4 - 4));
                    g.setColor(Color.white);
                    g.fillRect(6, 6, w - 2 - 2 - 4 - 4, h - 2 - 2 - 4 - 4);
                    g.setColor(Color.decode("0x" + this.m_cell.getMinorColor()));
                    if (dy > 0) {
                        g.fillRect(6, h - 2 - 4 - dy + 1, w - 2 - 2 - 4 - 4 + 1, dy);
                    }
                    g.drawRect(6, 6, w - 2 - 2 - 4 - 4, h - 2 - 2 - 4 - 4);
                }
            } else {
                g.setColor(this.getBackground());
                g.fillRect(2, 2, this.getWidth() - 3, this.getHeight() - 3);
            }
            if (this.isFocusOwner()) {
                g.setColor(UIManager.getColor("Table.focusCellForeground"));
                LookAndFeelUtility.drawFocus(g, 1, 1, this.getWidth() - 2, this.getHeight() - 2);
            }
            g.setColor(this.getForeground());
            g.setFont(this.getFont());
            String s = this.getText();
            if (s != null) {
                FontMetrics fm = g.getFontMetrics();
                int sWidth = fm.stringWidth(s);
                int dx = Math.max(0, this.getWidth() - 4 - sWidth);
                g.clipRect(2, 2, this.getWidth() - 4, this.getHeight() - 4);
                g.drawString(s, 2 + dx / 2, this.getHeight() - 2 - fm.getDescent());
            }
        }
        finally {
            g.setClip(oldShape);
        }
    }
}

